<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere um cliente
	-- cristofer 18/05/2006 15:26:31 - CRIADO
	--->
	<cffunction name='ins_cliente' displayname='Insere um cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLIENTE' required='yes'>
		<cfargument name="NOME" required="yes">
		<cfargument name="COD_PESSOA" required="yes">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_ins_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CLIENTE'  value='#arguments.CLIENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID' variable='retorno.CLIENTE_ID'>
				</cfstoredproc>		
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cliente inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um cliente
	-- cristofer 18/05/2006 15:27:21 - CRIADO
	--->
	<cffunction name='upd_cliente' displayname='Altera um cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='CLIENTE' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name="COD_PESSOA" required="yes">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_alt_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CLIENTE'  value='#arguments.CLIENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				</cfstoredproc>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cliente alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um cliente
	-- cristofer 18/05/2006 15:27:52 - CRIADO
	--->
	<cffunction name='del_cliente' displayname='Exclui um cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLIENTE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_del_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cliente excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um recurso
	-- cristofer 19/05/2006 08:30:49 - CRIADO
	-- Jonas 01/04/2009 17:25 - EDITADO
	-- Jonas 03/04/2009 14:00 - EDITADO
	--->
	<cffunction name='ins_recurso' displayname='Insere um recurso' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NOME' required='yes'>
		<cfargument name='NOME_COMPLETO' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='TECNICO' required='no' default="0">
		<cfargument name='EXIBIR_RANKING' required='no' default="0">
		<cfargument name='EMAIL' required='yes'>
		<cfargument name='CUSTO_HORA' required='no' default="0">
		<cfargument name='COD_PESSOA' required='no' default="">
        <cfargument name='PRODUTIVIDADE' required='no' default="0">
		<cfargument name='ATIVO' required='no' default="0">  		
		<cftry>
			<cfif not len(trim(arguments.exibir_ranking))>
				<cfset arguments.exibir_ranking = 0>
			</cfif>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_ins_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_COMPLETO'  value='#arguments.NOME_COMPLETO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TECNICO'  value='#arguments.TECNICO#'  null='#iif(len(trim(arguments.TECNICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXIBIR_RANKING'  value='#arguments.EXIBIR_RANKING#'  null='#iif(len(trim(arguments.EXIBIR_RANKING)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUSTO_HORA'  value='#arguments.CUSTO_HORA#'  null='#iif(len(trim(arguments.CUSTO_HORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTIVIDADE'  value='#arguments.PRODUTIVIDADE#'  null='#iif(len(trim(arguments.PRODUTIVIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID' variable='retorno.RECURSO_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recurso inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um recurso
	-- cristofer 19/05/2006 08:31:34 - CRIADO
	-- Jonas 01/04/2009 17:28 - EDITADO
	--->
	<cffunction name='upd_recurso' displayname='Altera um recurso' access='remote' returntype='Struct' output='true'>;
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='NOME_COMPLETO' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='TECNICO' required='no' default="0">
		<cfargument name='EXIBIR_RANKING' required='no' default="0">
		<cfargument name='EMAIL' required='yes'>
		<cfargument name='CUSTO_HORA' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='ATIVO' required='no' default="0">
        <cfargument name='PRODUTIVIDADE' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_alt_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_COMPLETO'  value='#arguments.NOME_COMPLETO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TECNICO'  value='#arguments.TECNICO#'  null='#iif(len(trim(arguments.TECNICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXIBIR_RANKING'  value='#arguments.EXIBIR_RANKING#'  null='#iif(len(trim(arguments.EXIBIR_RANKING)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUSTO_HORA'  value='#arguments.CUSTO_HORA#'  null='#iif(len(trim(arguments.CUSTO_HORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTIVIDADE'  value='#arguments.PRODUTIVIDADE#'  null='#iif(len(trim(arguments.PRODUTIVIDADE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recurso alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um recurso
	-- cristofer 19/05/2006 08:32:09 - CRIADO
	--->
	<cffunction name='del_recurso' displayname='Exclui um recurso' access='remote' returntype='Struct' output='true'>;
		<cfargument name='RECURSO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_del_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recurso excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um projeto
	-- cristofer 02/08/2006 14:48:38 - CRIADO
	--->
	<cffunction name='ins_projeto' displayname='Insere um projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_FECHAMENTO' required='yes'>
		<cfargument name='PROPOSITO' required='yes'>
		<cfargument name='ESCOPO' required='yes'>
		<cfargument name='LIMITACAO' required='yes'>
		<cfargument name='META' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FECHAMENTO'  value='#arguments.DATA_FECHAMENTO#' >
					<cfprocparam type='IN' cfsqltype='cf_sql_longvarchar' dbvarname='P_PROPOSITO'  value='#arguments.PROPOSITO#'  null='#iif(len(trim(arguments.PROPOSITO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_longvarchar' dbvarname='P_ESCOPO'  value='#arguments.ESCOPO#'  null='#iif(len(trim(arguments.ESCOPO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_longvarchar' dbvarname='P_LIMITACAO'  value='#arguments.LIMITACAO#'  null='#iif(len(trim(arguments.LIMITACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_longvarchar' dbvarname='P_META'  value='#arguments.META#'  null='#iif(len(trim(arguments.META)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID' variable='retorno.PROJETO_ID'  >
				</cfstoredproc>
				<cfscript>
					if(arguments.operacao neq 12) {
						arguments.projeto_id = retorno.projeto_id;
						this.upd_projeto_auxiliares(argumentCollection = arguments);
					}
				</cfscript>	
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Projeto inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um projeto
	-- cristofer 02/08/2006 14:48:38 - CRIADO
	--->
	<cffunction name='ins_projeto_new' displayname='Insere um projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_FECHAMENTO' required='yes'>
		<cfargument name='PROPOSITO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FECHAMENTO'  value='#arguments.DATA_FECHAMENTO#' >
					<cfprocparam type='IN' cfsqltype='cf_sql_longvarchar' dbvarname='P_PROPOSITO'  value='#arguments.PROPOSITO#'  null='#iif(len(trim(arguments.PROPOSITO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID' variable='retorno.PROJETO_ID'  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Projeto inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Altera um projeto
	-- cristofer 02/08/2006 14:49:38 - CRIADO
	--->
	<cffunction name='upd_projeto' displayname='Altera um projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_FECHAMENTO' required='yes'>
		<cfargument name='PROPOSITO' required='yes'>
		<cfargument name='ESCOPO' required='yes'>
		<cfargument name='LIMITACAO' required='yes'>
		<cfargument name='META' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FECHAMENTO'  value='#arguments.DATA_FECHAMENTO#' >
					<cfprocparam type='IN' cfsqltype='cf_sql_longvarchar' dbvarname='P_PROPOSITO'  value='#arguments.PROPOSITO#'  null='#iif(len(trim(arguments.PROPOSITO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_longvarchar' dbvarname='P_ESCOPO'  value='#arguments.ESCOPO#'  null='#iif(len(trim(arguments.ESCOPO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_longvarchar' dbvarname='P_LIMITACAO'  value='#arguments.LIMITACAO#'  null='#iif(len(trim(arguments.LIMITACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_longvarchar' dbvarname='P_META'  value='#arguments.META#'  null='#iif(len(trim(arguments.META)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					this.upd_projeto_auxiliares(argumentCollection = arguments);
				</cfscript>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Projeto alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um projeto
	-- cristofer 02/08/2006 14:49:38 - CRIADO
	--->
	<cffunction name='upd_projeto_new' displayname='Altera um projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_FECHAMENTO' required='yes'>
		<cfargument name='PROPOSITO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FECHAMENTO'  value='#arguments.DATA_FECHAMENTO#' >
					<cfprocparam type='IN' cfsqltype='cf_sql_longvarchar' dbvarname='P_PROPOSITO'  value='#arguments.PROPOSITO#'  null='#iif(len(trim(arguments.PROPOSITO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Projeto alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Manipula as tabelas auxiliares do projeto
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_acronimos" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>
			<!--- Abreviaes/Acronimos --->
			<cfscript>
				retorno.projeto_id = arguments.projeto_id;
				v_abreviacao = this.ListaToArray (lista = arguments, variavel = "ABREVIACAO_ACRONIMO_ACRONIMOS");
				v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_ACRONIMO_ACRONIMOS");
				v_acronimo_id = this.ListaToArray (lista = arguments, variavel = "ACRONIMO_ID_ACRONIMOS");
				v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ACRONIMOS, lista2 = ArrayToList(v_acronimo_id));
			</cfscript>
			<cfloop list="#v_excluir#" delimiters="," index="l_id">
				<cfscript>
					this.del_projeto_acronimo (projeto_id = retorno.projeto_id,
												acronimo_id = l_id);
				</cfscript>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_acronimo_id)#" index="count">
				<cfscript>
					if(not len(trim(v_acronimo_id[count]))) {
						this.ins_projeto_acronimo(projeto_id = retorno.projeto_id
													,abreviacao = v_abreviacao[count]
													,descricao = v_descricao[count]);
					} else {
						this.upd_projeto_acronimo(projeto_id = retorno.projeto_id
													,acronimo_id = v_acronimo_id[count]
													,abreviacao = v_abreviacao[count]
													,descricao = v_descricao[count]);
					}
				</cfscript>
			</cfloop>
			<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Acronimos salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Manipula as tabelas auxiliares do projeto
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_equipes" access="remote" returntype="struct" output="true">
		<cfargument name="INTERNO" required="yes">
		<cftry>
			<cftransaction action='begin'>	
				<cfscript>
					retorno.projeto_id = arguments.projeto_id;
					v_equipe_id = this.ListaToArray (lista = arguments, variavel = "PROJETO_EQUIPE_ID_EQUIPE");
					v_recurso_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_EQUIPE");
					v_funcao_id  = this.ListaToArray (lista = arguments, variavel = "FUNCAO_ID_EQUIPE");
					v_observacao = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_EQUIPE");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_EQUIPE, lista2 = ArrayToList(v_equipe_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_projeto_equipe (projeto_id = retorno.projeto_id,
													projeto_equipe_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_equipe_id)#" index="count">
					<cfscript>
						if(not len(trim(v_equipe_id[count]))) {
							this.ins_projeto_equipe(projeto_id = retorno.projeto_id,
													recurso_id = v_recurso_id[count],
													funcao_id = v_funcao_id[count],
													observacao = v_observacao[count],
													interno = arguments.interno);
						} else {
							this.upd_projeto_equipe(projeto_id = retorno.projeto_id,
													recurso_id = v_recurso_id[count],
													funcao_id = v_funcao_id[count],
													observacao = v_observacao[count],
													interno = arguments.interno,
													projeto_equipe_id = v_equipe_id[count]);
						}
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Equipe salva com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	
	<!--- 
	-- PROPSITO 
	-- Manipula as tabelas auxiliares do projeto
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_requisitos" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>		
				<!--- Requisitos --->
				<cfscript>
					retorno.projeto_id = arguments.projeto_id;
					v_id = this.ListaToArray (lista = arguments, variavel = "PROJETO_REQUISITO_ID_REQUISITOS");
					v_requisito_id = this.ListaToArray (lista = arguments, variavel = "REQUISITO_ID_REQUISITOS");
					v_status = this.ListaToArray (lista = arguments, variavel = "STATUS_REQUISITO_REQUISITOS");
					v_observacao = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_REQUISITO_REQUISITOS");
					v_tipo_id = this.ListaToArray (lista = arguments, variavel = "TIPO_REQUISITO_ID_REQUISITOS");
					v_tamanho_id = this.ListaToArray (lista = arguments, variavel = "TAMANHO_REQUISITO_ID_REQUISITOS");
					v_complexidade_id = this.ListaToArray (lista = arguments, variavel = "COMPLEXIDADE_REQUISITO_ID_REQUISITOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_REQUISITOS, lista2 = ArrayToList(v_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_projeto_requisito (projeto_id = retorno.projeto_id,
													projeto_requisito_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_id)#" index="count">
					<cfscript>
						if(not len(trim(v_id[count]))) {
							this.ins_projeto_requisito(	projeto_id 	= retorno.projeto_id,
														requisito_id = v_requisito_id[count],
														status_id = v_status[count],
														observacao = v_observacao[count],
														tipo_id = v_tipo_id[count],
														tamanho_id = v_tamanho_id[count],
														complexidade_id = v_complexidade_id[count]);
						} else {
							this.upd_projeto_requisito(	projeto_id 	= retorno.projeto_id,
														requisito_id = v_requisito_id[count],
														status_id = v_status[count],
														observacao = v_observacao[count],
														projeto_requisito_id = v_id[count],
														tipo_id = v_tipo_id[count],
														tamanho_id = v_tamanho_id[count],
														complexidade_id = v_complexidade_id[count]);
						}
					</cfscript>
				</cfloop>
		
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Requisitos salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera os valores das etapas do ciclo de vida do projeto
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_ciclo_vidas" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>
				<!--- Ciclo Vida --->
				<cfscript>
					retorno.projeto_id = arguments.projeto_id;
					v_tempo = this.ListaToArray (lista = arguments, variavel = "PERC_TEMPO_CICLO_VIDA");
					v_etapa_id = this.ListaToArray (lista = arguments, variavel = "ETAPA_ID_CICLO_VIDA");
					v_num_etapa = this.ListaToArray (lista = arguments, variavel = "NUM_ETAPA_CICLO_VIDA");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CICLO_VIDA, lista2 = ArrayToList(v_etapa_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_projeto_ciclo_vida (projeto_id = retorno.projeto_id,
													 etapa_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_tempo)#" index="count">
					<cfscript>
						this.ins_projeto_ciclo_vida(projeto_id 	= retorno.projeto_id,
													perc_tempo 	= v_tempo[count],
													etapa_id	= v_etapa_id[count],
													num_etapa	= v_num_etapa[count]);
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Etapas do ciclo de vida salvas com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Salva os recursos de treinamentos
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_treinamentos" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>
				<!--- Treinamento --->
				<cfscript>
					retorno.projeto_id = arguments.projeto_id;
					v_treinamento_id = this.ListaToArray (lista = arguments, variavel = "TREINAMENTO_ID_TREINAMENTOS");
					v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_RECURSO_TREINAMENTOS");
					v_realizar_ate  = this.ListaToArray (lista = arguments, variavel = "LIMITE_RECURSO_TREINAMENTOS");
					v_criterio = this.ListaToArray (lista = arguments, variavel = "CRITERIO_RECURSO_TREINAMENTOS");
					v_status = this.ListaToArray (lista = arguments, variavel = "STATUS_RECURSO_TREINAMENTOS");
					v_tipo_id = this.ListaToArray (lista = arguments, variavel = "TIPO_ID_TREINAMENTOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_TREINAMENTOS, lista2 = ArrayToList(v_treinamento_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_projeto_recurso (projeto_id = retorno.projeto_id,
													 treinamento_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_treinamento_id)#" index="count">
					<cfscript>
						if(not len(trim(v_treinamento_id[count]))) {
							this.ins_projeto_recurso(projeto_id = retorno.projeto_id,
														descricao	= v_descricao[count],
														realizar_ate	= v_realizar_ate[count],
														criterio_participacao = v_criterio[count],
														status	= v_status[count],
														tipo_id	= v_tipo_id[count]);
						} else {
							this.upd_projeto_recurso(projeto_id = retorno.projeto_id,
														descricao	= v_descricao[count],
														realizar_ate	= v_realizar_ate[count],
														criterio_participacao = v_criterio[count],
														status	= v_status[count],
														tipo_id	= v_tipo_id[count],
														treinamento_id = v_treinamento_id[count]);
						}
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recursos de treinamento salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Salva os recursos de infra-estrutura
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_infra_estruturas" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>	
				<!--- Infra-estrutura --->
				<cfscript>
					retorno.projeto_id = arguments.projeto_id;
					v_infra_estrutura_id = this.ListaToArray (lista = arguments, variavel = "INFRA_ESTRUTURA_ID_RECURSOS_IE");
					v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_RECURSO_IE_RECURSOS_IE");
					v_disponibilizar_ate  = this.ListaToArray (lista = arguments, variavel = "LIMITE_RECURSO_IE_RECURSOS_IE");
					v_status = this.ListaToArray (lista = arguments, variavel = "STATUS_RECURSO_IE_RECURSOS_IE");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RECURSOS_IE, lista2 = ArrayToList(v_infra_estrutura_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_projeto_infra_estrutura (projeto_id = retorno.projeto_id,
															infra_estrutura_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_infra_estrutura_id)#" index="count">
					<cfscript>
						if(not len(trim(v_infra_estrutura_id[count]))) {
							this.ins_projeto_infra_estrutura(projeto_id = retorno.projeto_id,
															descricao	= v_descricao[count],
															disponibilizar_ate	= v_disponibilizar_ate[count],
															status	= v_status[count]);
						} else {
							this.upd_projeto_infra_estrutura(projeto_id = retorno.projeto_id,
															descricao	= v_descricao[count],
															disponibilizar_ate	= v_disponibilizar_ate[count],
															status	= v_status[count],
															infra_estrutura_id = v_infra_estrutura_id[count]);
						}
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recursos de infra-estrutura salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Salva os outros recursos
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_outros_recursos" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>	
				<!--- Outros Recursos --->
				<cfscript>
					retorno.projeto_id = arguments.projeto_id;
					this.upd_projeto_recursos(projeto_id = retorno.projeto_id,
												descricao = arguments.OUTROS_RECURSOS);
				</cfscript>	
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Outros recursos salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Salva os outros recursos
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_fatores" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>
				<!--- Fatores Tecnicos --->
				<cfscript>
					retorno.projeto_id = arguments.projeto_id;
					v_fator_id = this.ListaToArray (lista = arguments, variavel = "FATOR_ID");
					v_projeto_fator_id = this.ListaToArray (lista = arguments, variavel = "PROJETO_FATOR_ID");
					v_avaliacao = this.ListaToArray (lista = arguments, variavel = "AVALIACAO");
					v_valor = this.ListaToArray (lista = arguments, variavel = "VALOR");
					v_justificativa = this.ListaToArray (lista = arguments, variavel = "JUSTIFICATIVA");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_fator_id)#" index="count">
					<cfscript>
						if(not len(trim(v_projeto_fator_id[count]))) {
							this.ins_projeto_fator(	projeto_id 	= retorno.projeto_id,
													fator_id = v_fator_id[count],
													avaliacao = v_avaliacao[count],
													valor = v_valor[count],
													justificativa = v_justificativa[count]);
						} else {
							this.upd_projeto_fator(	projeto_id 	= retorno.projeto_id,
													fator_id = v_fator_id[count],
													avaliacao = v_avaliacao[count],
													valor = v_valor[count],
													justificativa = v_justificativa[count],
													projeto_fator_id = v_projeto_fator_id[count]);
						}
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fatores salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Salva os outros recursos
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_riscos" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>	
				<!--- Riscos --->
				<cfscript>
					retorno.projeto_id = arguments.projeto_id;
					v_risco_id = this.ListaToArray (lista = arguments, variavel = "RISCO_ID_RISCOS");
					v_categoria = this.ListaToArray (lista = arguments, variavel = "CATEGORIA_RISCO_RISCOS");
					v_risco = this.ListaToArray (lista = arguments, variavel = "RISCO_RISCOS");
					v_probabilidade = this.ListaToArray (lista = arguments, variavel = "PROBABILIDADE_RISCO_RISCOS");
					v_impacto = this.ListaToArray (lista = arguments, variavel = "IMPACTO_RISCO_RISCOS");
					v_exposicao = this.ListaToArray (lista = arguments, variavel = "EXPOSICAO_RISCO_RISCOS");
					v_status = this.ListaToArray (lista = arguments, variavel = "STATUS_RISCO_RISCOS");
					v_estrategia = this.ListaToArray (lista = arguments, variavel = "ESTRATEGIA");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RISCOS, lista2 = ArrayToList(v_risco_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_projeto_risco (projeto_id = retorno.projeto_id,
												risco_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_risco_id)#" index="count">
					<cfscript>
						if(not len(trim(v_risco_id[count]))) {
							this.ins_projeto_risco(	projeto_id 	= retorno.projeto_id,
													descricao	= v_risco[count],
													categoria_id= v_categoria[count],
													probabilidade_id = v_probabilidade[count],
													impacto_id = v_impacto[count],
													exposicao_id = v_exposicao[count],
													status_id = v_status[count],
													estrategia = v_estrategia[count]);
						} else {
							this.upd_projeto_risco(	projeto_id 	= retorno.projeto_id,
													descricao	= v_risco[count],
													categoria_id= v_categoria[count],
													probabilidade_id = v_probabilidade[count],
													impacto_id = v_impacto[count],
													exposicao_id = v_exposicao[count],
													status_id = v_status[count],
													risco_id = v_risco_id[count],
													estrategia = v_estrategia[count]);
						}
					</cfscript>
					
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Riscos salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Salva os outros recursos
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_anexos" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>	
				<!--- Riscos --->
				<cfscript>
					retorno.projeto_id = arguments.projeto_id;
					v_projeto_anexo_id = this.ListaToArray (lista = arguments, variavel = "PROJETO_ANEXO_ID_ANEXOS");
					v_anexo_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_projeto_anexo_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_projeto_anexo (projeto_anexo_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_projeto_anexo_id)#" index="count">
					<cfscript>
						if(not len(trim(v_projeto_anexo_id[count]))) {
							this.ins_projeto_anexo(	projeto_id 	= retorno.projeto_id,
													anexo_id	= v_anexo_id[count]);
						} else {
							this.upd_projeto_anexo(	projeto_id 	= retorno.projeto_id,
													anexo_id	= v_anexo_id[count],
													projeto_anexo_id = v_projeto_anexo_id[count]);
						}
					</cfscript>
					
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Anexos salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	
	<!--- 
	-- PROPSITO 
	-- Salva os outros recursos
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_tarefa_anexos" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>	
				<!--- Riscos --->
				<cfscript>
					retorno.tarefa_id = arguments.tarefa_id;
					v_anexo_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_anexo_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_tarefa_anexo (tarefa_id = retorno.tarefa_id,
												anexo_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_anexo_id)#" index="count">
					<cfscript>
							this.ins_tarefa_anexo(	tarefa_id 	= retorno.tarefa_id,
													anexo_id	= v_anexo_id[count]);
					</cfscript>
					
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Anexos salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Salva os anexos da reuniao recursos
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_reuniao_anexos_private" access="remote" returntype="struct" output="true">
				<!--- Riscos --->
				<cfscript>
					retorno.reuniao_id = arguments.reuniao_id;
					v_anexo_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_anexo_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_reuniao_anexo (reuniao_id = retorno.reuniao_id,
												anexo_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_anexo_id)#" index="count">
					<cfscript>
							this.ins_reuniao_anexo(	reuniao_id 	= retorno.reuniao_id,
													anexo_id	= v_anexo_id[count]);
					</cfscript>
					
				</cfloop>
		<cfreturn structnew() />
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Salva os Custos do projeto
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_custos" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>	
				<!--- Riscos --->
				<cfif arguments.estimado eq 1>
					<cfstoredproc procedure='kmm.pkg_projeto.prc_set_projeto_custo_hora' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUSTO_HORA'  value='#arguments.CUSTO_HORA#'  null='#iif(len(trim(arguments.CUSTO_HORA)), de('no'), de('yes'))#'>
					</cfstoredproc>
				</cfif>
				<cfscript>
					retorno.projeto_id = arguments.projeto_id;
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_CUSTOS_COMP");
					v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_CUSTO_COMP_CUSTOS_COMP");
					v_valor = this.ListaToArray (lista = arguments, variavel = "VALOR_CUSTO_COMP_CUSTOS_COMP");
					v_realizacao = this.ListaToArray (lista = arguments, variavel = "REALIZACAO_CUSTOS_COMP");
					v_tipo_id = this.ListaToArray (lista = arguments, variavel = "TIPO_ID_CUSTOS_COMP");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CUSTOS_COMP, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_projeto_custo_complementar (item_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_projeto_custo_complementar(	projeto_id 	= retorno.projeto_id,
																	descricao	= v_descricao[count],
																	valor 		= v_valor[count],
																	realizacao	= v_realizacao[count],
																	tipo_id		= v_tipo_id[count],
																	estimado	= arguments.estimado);
						} else {
							this.upd_projeto_custo_complementar(	projeto_id 	= retorno.projeto_id,
																	descricao	= v_descricao[count],
																	valor		= v_valor[count],
																	realizacao	= v_realizacao[count],
																	tipo_id		= v_tipo_id[count],
																	estimado	= arguments.estimado,
																	item_id		= v_item_id[count]);
						}
					</cfscript>
					
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Custos salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Salva os Custos do projeto
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_tarefa_arquivo" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>	
				<!--- Riscos --->
				<cfscript>
						retorno.tarefa_id = arguments.tarefa_id;
						v_arquivo_id = this.ListaToArray (lista = arguments, variavel = "ARQUIVO_ID_ARQUIVOS");
						v_nome = this.ListaToArray (lista = arguments, variavel = "ARQUIVO_NOME_ARQUIVOS");
						v_caminho = this.ListaToArray (lista = arguments, variavel = "ARQUIVO_CAMINHO_ARQUIVOS");
						v_comentario = this.ListaToArray (lista = arguments, variavel = "COMENTARIO_ARQUIVO_ARQUIVOS");
						conn = CreateObject("component", "_transportes.consulta.cfc_kmm");
						qrArquivo = conn.get_tarefa_arquivo(tarefa_id = retorno.tarefa_id);
					</cfscript>
					<cfoutput query="qrArquivo">
						<cfif not ListFind(ArrayToList(v_arquivo_id), qrArquivo.arquivo_id)>
							<cfscript>
								this.del_tarefa_arquivo(arquivo_id = qrArquivo.arquivo_id,
														tarefa_id = retorno.tarefa_id);
							</cfscript>
						</cfif>
					</cfoutput>
					<cfloop from="1" to="#ArrayLen(v_arquivo_id)#" index="count">
						<cfscript>
								res = this.ins_arquivo_caminho(   caminho		= v_caminho[count],
															nome		= v_nome[count],
															comentario	= v_comentario[count]);
								this.ins_tarefa_arquivo (tarefa_id = retorno.tarefa_id,
														 arquivo_id = res.arquivo_id);
						</cfscript>
					</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Arquivos salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Salva os Custos do projeto
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_reuniao_planejamentos" access="remote" returntype="struct" output="true">
		<cftry>
			<cftransaction action='begin'>	
				<cfscript>
					retorno.projeto_id = arguments.projeto_id;
					v_planejamento_id = this.ListaToArray (lista = arguments, variavel = "PLANEJAMENTO_ID_PLANEJAMENTOS");
					v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_PLANEJAMENTOS");
					v_tipo_id = this.ListaToArray (lista = arguments, variavel = "TIPO_ID_PLANEJAMENTOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_PLANEJAMENTOS, lista2 = ArrayToList(v_planejamento_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_projeto_reuniao_planejamento (planejamento_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_planejamento_id)#" index="count">
					<cfscript>
						if(not len(trim(v_planejamento_id[count]))) {
							this.ins_projeto_reuniao_planejamento(	projeto_id 	= retorno.projeto_id,
																	descricao	= v_descricao[count],
																	tipo_id		= v_tipo_id[count]);
						} else {
							this.upd_projeto_reuniao_planejamento(	projeto_id 	= retorno.projeto_id,
																	descricao	= v_descricao[count],
																	tipo_id		= v_tipo_id[count],
																	planejamento_id = v_planejamento_id[count]);
						}
					</cfscript>
					
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Planejamentos de reunio salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Manipula as tabelas auxiliares do projeto
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="upd_projeto_auxiliares" access="remote" returntype="void" output="true">
		<!--- Abreviaes/Acronimos --->
		<cfscript>
			retorno.projeto_id = arguments.projeto_id;
			v_abreviacao = this.ListaToArray (lista = arguments, variavel = "ABREVIACAO_ACRONIMO_ACRONIMOS");
			v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_ACRONIMO_ACRONIMOS");
			v_acronimo_id = this.ListaToArray (lista = arguments, variavel = "ACRONIMO_ID_ACRONIMOS");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ACRONIMOS, lista2 = ArrayToList(v_acronimo_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_acronimo (projeto_id = retorno.projeto_id,
											acronimo_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_acronimo_id)#" index="count">
			<cfscript>
				if(not len(trim(v_acronimo_id[count]))) {
					this.ins_projeto_acronimo(projeto_id = retorno.projeto_id
												,abreviacao = v_abreviacao[count]
												,descricao = v_descricao[count]);
				} else {
					this.upd_projeto_acronimo(projeto_id = retorno.projeto_id
												,acronimo_id = v_acronimo_id[count]
												,abreviacao = v_abreviacao[count]
												,descricao = v_descricao[count]);
				}
			</cfscript>
		</cfloop>
		<!--- Equipe Interna --->
		<cfscript>
			v_equipe_id = this.ListaToArray (lista = arguments, variavel = "PROJETO_EQUIPE_ID_KMM_EQUIPE_KMM");
			v_recurso_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_KMM_EQUIPE_KMM");
			v_funcao_id  = this.ListaToArray (lista = arguments, variavel = "FUNCAO_ID_KMM_EQUIPE_KMM");
			v_observacao = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_KMM_EQUIPE_KMM");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_EQUIPE_KMM, lista2 = ArrayToList(v_equipe_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_equipe (projeto_id = retorno.projeto_id,
											projeto_equipe_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_equipe_id)#" index="count">
			<cfscript>
				if(not len(trim(v_equipe_id[count]))) {
					this.ins_projeto_equipe(projeto_id = retorno.projeto_id,
											recurso_id = v_recurso_id[count],
											funcao_id = v_funcao_id[count],
											observacao = v_observacao[count],
											interno = 1);
				} else {
					this.upd_projeto_equipe(projeto_id = retorno.projeto_id,
											recurso_id = v_recurso_id[count],
											funcao_id = v_funcao_id[count],
											observacao = v_observacao[count],
											interno = 1,
											projeto_equipe_id = v_equipe_id[count]);
				}
			</cfscript>
		</cfloop>
		<!--- Equipe Cliente --->
		<cfscript>
			v_equipe_id = this.ListaToArray (lista = arguments, variavel = "PROJETO_EQUIPE_ID_CLIENTE_EQUIPE_CLIENTE");
			v_recurso_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_CLIENTE_EQUIPE_CLIENTE");
			v_funcao_id  = this.ListaToArray (lista = arguments, variavel = "FUNCAO_ID_CLIENTE_EQUIPE_CLIENTE");
			v_observacao = this.ListaToArray (lista = arguments, variavel = "EXPECTATIVA_CLIENTE_EQUIPE_CLIENTE");
			v_toma_decisao = this.ListaToArray (lista = arguments, variavel = "DECIDE_CLIENTE_EQUIPE_CLIENTE");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_EQUIPE_CLIENTE, lista2 = ArrayToList(v_equipe_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_equipe (projeto_id = retorno.projeto_id,
											projeto_equipe_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_equipe_id)#" index="count">
			<cfscript>
				if(not len(trim(v_equipe_id[count]))) {
					this.ins_projeto_equipe(projeto_id = retorno.projeto_id,
											recurso_id = v_recurso_id[count],
											funcao_id = v_funcao_id[count],
											observacao = v_observacao[count],
											interno = 0);
				} else {
					this.upd_projeto_equipe(projeto_id = retorno.projeto_id,
											recurso_id = v_recurso_id[count],
											funcao_id = v_funcao_id[count],
											observacao = v_observacao[count],
											interno = 0,
											projeto_equipe_id = v_equipe_id[count]);
				}
			</cfscript>
		</cfloop>
		
		<!--- Equipe Parceiros --->
		<cfscript>
			v_equipe_id = this.ListaToArray (lista = arguments, variavel = "PROJETO_EQUIPE_ID_PARC_EQUIPE_PARC");
			v_recurso_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_PARC_EQUIPE_PARC");
			v_funcao_id  = this.ListaToArray (lista = arguments, variavel = "FUNCAO_ID_PARC_EQUIPE_PARC");
			v_observacao = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_PARC_EQUIPE_PARC");
			v_toma_decisao = this.ListaToArray (lista = arguments, variavel = "DECIDE_PARC_EQUIPE_PARC");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_EQUIPE_PARC, lista2 = ArrayToList(v_equipe_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_equipe (projeto_id = retorno.projeto_id,
											projeto_equipe_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_equipe_id)#" index="count">
			<cfscript>
				if(not len(trim(v_equipe_id[count]))) {
					this.ins_projeto_equipe(projeto_id = retorno.projeto_id,
											recurso_id = v_recurso_id[count],
											funcao_id = v_funcao_id[count],
											observacao = v_observacao[count],
											interno = 2);
				} else {
					this.upd_projeto_equipe(projeto_id = retorno.projeto_id,
											recurso_id = v_recurso_id[count],
											funcao_id = v_funcao_id[count],
											observacao = v_observacao[count],
											interno = 2,
											projeto_equipe_id = v_equipe_id[count]);
				}
			</cfscript>
		</cfloop>
		
		<!--- Cronograma --->
		<cfscript>
			v_cronograma_id = this.ListaToArray (lista = arguments, variavel = "CRONOGRAMA_ID_CRONOGRAMA");
			v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_CRONOGRAMA_CRONOGRAMA");
			v_inicio  = this.ListaToArray (lista = arguments, variavel = "INICIO_CRONOGRAMA_CRONOGRAMA");
			v_termino = this.ListaToArray (lista = arguments, variavel = "TERMINO_CRONOGRAMA_CRONOGRAMA");
			v_responsavel = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_CRONOGRAMA_CRONOGRAMA");
			v_observacao = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_CRONOGRAMA_CRONOGRAMA");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CRONOGRAMA, lista2 = ArrayToList(v_cronograma_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_cronograma (projeto_id = retorno.projeto_id,
											 cronograma_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_cronograma_id)#" index="count">
			<cfscript>
				if(not len(trim(v_cronograma_id[count]))) {
					this.ins_projeto_cronograma(projeto_id 	= retorno.projeto_id,
												descricao	= v_descricao[count],
												data_inicio	= v_inicio[count],
												data_termino= v_termino[count],
												responsavel	= v_responsavel[count],
												observacao	= v_observacao[count]);
				} else {
					this.upd_projeto_cronograma(projeto_id 	= retorno.projeto_id,
												descricao	= v_descricao[count],
												data_inicio	= v_inicio[count],
												data_termino= v_termino[count],
												responsavel	= v_responsavel[count],
												observacao	= v_observacao[count],
												cronograma_id = v_cronograma_id[count]);
				}
			</cfscript>
		</cfloop>
		
		<!--- Treinamento --->
		<cfscript>
			v_treinamento_id = this.ListaToArray (lista = arguments, variavel = "TREINAMENTO_ID_TREINAMENTOS");
			v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_RECURSO_TREINAMENTOS");
			v_realizar_ate  = this.ListaToArray (lista = arguments, variavel = "LIMITE_RECURSO_TREINAMENTOS");
			v_criterio = this.ListaToArray (lista = arguments, variavel = "CRITERIO_RECURSO_TREINAMENTOS");
			v_status = this.ListaToArray (lista = arguments, variavel = "STATUS_RECURSO_TREINAMENTOS");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_TREINAMENTOS, lista2 = ArrayToList(v_treinamento_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_treinamento (projeto_id = retorno.projeto_id,
											 cronograma_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_treinamento_id)#" index="count">
			<cfscript>
				if(not len(trim(v_treinamento_id[count]))) {
					this.ins_projeto_treinamento(projeto_id = retorno.projeto_id,
												descricao	= v_descricao[count],
												realizar_ate	= v_realizar_ate[count],
												criterio_participacao = v_criterio[count],
												status	= v_status[count]);
				} else {
					this.upd_projeto_treinamento(projeto_id = retorno.projeto_id,
												descricao	= v_descricao[count],
												realizar_ate	= v_realizar_ate[count],
												criterio_participacao = v_criterio[count],
												status	= v_status[count],
												treinamento_id = v_treinamento_id[count]);
				}
			</cfscript>
		</cfloop>
		
		<!--- Infra-estrutura --->
		<cfscript>
			v_infra_estrutura_id = this.ListaToArray (lista = arguments, variavel = "INFRA_ESTRUTURA_ID_RECURSOS_IE");
			v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_RECURSO_IE_RECURSOS_IE");
			v_disponibilizar_ate  = this.ListaToArray (lista = arguments, variavel = "LIMITE_RECURSO_IE_RECURSOS_IE");
			v_status = this.ListaToArray (lista = arguments, variavel = "STATUS_RECURSO_IE_RECURSOS_IE");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RECURSOS_IE, lista2 = ArrayToList(v_infra_estrutura_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_infra_estrutura (projeto_id = retorno.projeto_id,
													infra_estrutura_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_infra_estrutura_id)#" index="count">
			<cfscript>
				if(not len(trim(v_infra_estrutura_id[count]))) {
					this.ins_projeto_infra_estrutura(projeto_id = retorno.projeto_id,
													descricao	= v_descricao[count],
													disponibilizar_ate	= v_disponibilizar_ate[count],
													status	= v_status[count]);
				} else {
					this.upd_projeto_infra_estrutura(projeto_id = retorno.projeto_id,
													descricao	= v_descricao[count],
													disponibilizar_ate	= v_disponibilizar_ate[count],
													status	= v_status[count],
													infra_estrutura_id = v_infra_estrutura_id[count]);
				}
			</cfscript>
		</cfloop>
		
		<!--- Outros Recursos --->
		<cfscript>
			this.upd_projeto_recursos(projeto_id = retorno.projeto_id,
										descricao = arguments.OUTROS_RECURSOS);
//			this.upd_projeto_observacoes(projeto_id = retorno.projeto_id,
//										produtividade = arguments.OBS_PRODUTIVIDADE,
//										improdutividade = arguments.OBS_IMPRODUTIVIDADE);
		</cfscript>		
		
		<!--- Riscos --->
		
		<cfscript>
			v_risco_id = this.ListaToArray (lista = arguments, variavel = "RISCO_ID_RISCOS");
			v_num_risco = this.ListaToArray (lista = arguments, variavel = "NUM_RISCO_RISCOS");
			v_categoria = this.ListaToArray (lista = arguments, variavel = "CATEGORIA_RISCO_RISCOS");
			v_risco = this.ListaToArray (lista = arguments, variavel = "RISCO_RISCOS");
			v_probabilidade = this.ListaToArray (lista = arguments, variavel = "PROBABILIDADE_RISCO_RISCOS");
			v_impacto = this.ListaToArray (lista = arguments, variavel = "IMPACTO_RISCO_RISCOS");
			v_exposicao = this.ListaToArray (lista = arguments, variavel = "EXPOSICAO_RISCO_RISCOS");
			v_status = this.ListaToArray (lista = arguments, variavel = "STATUS_RISCO_RISCOS");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RISCOS, lista2 = ArrayToList(v_risco_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_risco (projeto_id = retorno.projeto_id,
										risco_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_risco_id)#" index="count">
			<cfscript>
				if(not len(trim(v_risco_id[count]))) {
					this.ins_projeto_risco(	projeto_id 	= retorno.projeto_id,
											num_risco	= v_num_risco[count],
											descricao	= v_risco[count],
											categoria_id= v_categoria[count],
											probabilidade_id = v_probabilidade[count],
											impacto_id = v_impacto[count],
											exposicao_id = v_exposicao[count],
											status_id = v_status[count]);
				} else {
					this.upd_projeto_risco(	projeto_id 	= retorno.projeto_id,
											num_risco	= v_num_risco[count],
											descricao	= v_risco[count],
											categoria_id= v_categoria[count],
											probabilidade_id = v_probabilidade[count],
											impacto_id = v_impacto[count],
											exposicao_id = v_exposicao[count],
											status_id = v_status[count],
											risco_id = v_risco_id[count]);
				}
			</cfscript>
			
		</cfloop>
		
		<!---<!--- Casos de Uso --->
		<cfscript>
			v_caso_uso_id = this.ListaToArray (lista = arguments, variavel = "CASO_USO_ID_CASOS_USO");
			v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_CASO_USO_CASOS_USO");
			v_complexidade = this.ListaToArray (lista = arguments, variavel = "COMPLEXIDADE_CASO_USO_CASOS_USO");
			v_status = this.ListaToArray (lista = arguments, variavel = "STATUS_CASO_USO_CASOS_USO");
			v_observacao = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_CASO_USO_CASOS_USO");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CASOS_USO, lista2 = ArrayToList(v_caso_uso_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_caso_uso (projeto_id = retorno.projeto_id,
											caso_uso_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_caso_uso_id)#" index="count">
			<cfscript>
				if(not len(trim(v_caso_uso_id[count]))) {
					this.ins_projeto_caso_uso(	projeto_id 	= retorno.projeto_id,
												descricao = v_descricao[count],
												complexidade_id = v_complexidade[count],
												status_id = v_status[count],
												observacao = v_observacao[count]);
				} else {
					this.upd_projeto_caso_uso(	projeto_id 	= retorno.projeto_id,
												descricao = v_descricao[count],
												complexidade_id = v_complexidade[count],
												status_id = v_status[count],
												observacao = v_observacao[count],
												caso_uso_id = v_caso_uso_id[count]);
				}
			</cfscript>
		</cfloop>
		
		<!--- Atores --->
		<cfscript>
			v_ator_id = this.ListaToArray (lista = arguments, variavel = "ATOR_ID_ATORES");
			v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_ATOR_ATORES");
			v_interface = this.ListaToArray (lista = arguments, variavel = "INTERFACE_ATOR_ATORES");
			v_tipo = this.ListaToArray (lista = arguments, variavel = "TIPO_ID_ATOR_ATORES");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ATORES, lista2 = ArrayToList(v_ator_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_ator (projeto_id = retorno.projeto_id,
									   ator_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_ator_id)#" index="count">
			<cfscript>
				if(not len(trim(v_ator_id[count]))) {
					this.ins_projeto_ator(	projeto_id 	= retorno.projeto_id,
											descricao = v_descricao[count],
											interface = v_interface[count],
											tipo_id = v_tipo[count]);
				} else {
					this.upd_projeto_ator(	projeto_id 	= retorno.projeto_id,
											descricao = v_descricao[count],
											interface = v_interface[count],
											tipo_id = v_tipo[count],
											ator_id = v_ator_id[count]);
				}
			</cfscript>
		</cfloop>--->

		<!--- Fatores Tecnicos --->
		<cfscript>
			v_fator_id = this.ListaToArray (lista = arguments, variavel = "FATOR_ID_TECNICO_FTECNICOS");
			v_fator = this.ListaToArray (lista = arguments, variavel = "FATOR_FTECNICOS");
			v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_FATOR_FTECNICOS");
			v_avaliacao = this.ListaToArray (lista = arguments, variavel = "AVALIACAO_FATOR_FTECNICOS");
			v_valor = this.ListaToArray (lista = arguments, variavel = "VALOR_FATOR_FTECNICOS");
			v_justificativa = this.ListaToArray (lista = arguments, variavel = "JUSTIFICATIVA_FATOR_FTECNICOS");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_FTECNICOS, lista2 = ArrayToList(v_fator_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_fator (projeto_id = retorno.projeto_id,
									   fator_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_fator_id)#" index="count">
			<cfscript>
				if(not len(trim(v_fator_id[count]))) {
					this.ins_projeto_fator(	projeto_id 	= retorno.projeto_id,
											fator = v_fator[count],
											descricao = v_descricao[count],
											avaliacao = v_avaliacao[count],
											valor = v_valor[count],
											justificativa = v_justificativa[count],
											tipo_id = 1);
				} else {
					this.upd_projeto_fator(	projeto_id 	= retorno.projeto_id,
											fator = v_fator[count],
											descricao = v_descricao[count],
											avaliacao = v_avaliacao[count],
											valor = v_valor[count],
											justificativa = v_justificativa[count],
											tipo_id = 1,
											fator_id = v_fator_id[count]);
				}
			</cfscript>
		</cfloop>
		
		<!--- Fatores Ambientais --->
		<cfscript>
			v_fator_id = this.ListaToArray (lista = arguments, variavel = "FATOR_ID_AMB_FAMBIENTAIS");
			v_fator = this.ListaToArray (lista = arguments, variavel = "FATOR_AMB_FAMBIENTAIS");
			v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_FATOR_AMB_FAMBIENTAIS");
			v_avaliacao = this.ListaToArray (lista = arguments, variavel = "AVALIACAO_FATOR_AMB_FAMBIENTAIS");
			v_valor = this.ListaToArray (lista = arguments, variavel = "VALOR_FATOR_AMB_FAMBIENTAIS");
			v_justificativa = this.ListaToArray (lista = arguments, variavel = "JUSTIFICATIVA_FATOR_AMB_FAMBIENTAIS");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_FAMBIENTAIS, lista2 = ArrayToList(v_fator_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_fator (projeto_id = retorno.projeto_id,
									   fator_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_fator_id)#" index="count">
			<cfscript>
				if(not len(trim(v_fator_id[count]))) {
					this.ins_projeto_fator(	projeto_id 	= retorno.projeto_id,
											fator = v_fator[count],
											descricao = v_descricao[count],
											avaliacao = v_avaliacao[count],
											valor = v_valor[count],
											justificativa = v_justificativa[count],
											tipo_id = 2);
				} else {
					this.upd_projeto_fator(	projeto_id 	= retorno.projeto_id,
											fator = v_fator[count],
											descricao = v_descricao[count],
											avaliacao = v_avaliacao[count],
											valor = v_valor[count],
											justificativa = v_justificativa[count],
											tipo_id = 2,
											fator_id = v_fator_id[count]);
				}
			</cfscript>
		</cfloop>
		
		<!--- Requisitos --->
		<cfscript>
			v_id = this.ListaToArray (lista = arguments, variavel = "PROJETO_REQUISITO_ID_REQUISITOS");
			v_requisito_id = this.ListaToArray (lista = arguments, variavel = "REQUISITO_ID_REQUISITOS");
			v_status = this.ListaToArray (lista = arguments, variavel = "STATUS_REQUISITO_REQUISITOS");
			v_observacao = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_REQUISITO_REQUISITOS");
			v_tipo_id = this.ListaToArray (lista = arguments, variavel = "TIPO_REQUISITO_ID_REQUISITOS");
			v_tamanho_id = this.ListaToArray (lista = arguments, variavel = "TAMANHO_REQUISITO_ID_REQUISITOS");
			v_complexidade_id = this.ListaToArray (lista = arguments, variavel = "COMPLEXIDADE_REQUISITO_ID_REQUISITOS");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_REQUISITOS, lista2 = ArrayToList(v_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_requisito (projeto_id = retorno.projeto_id,
									   		projeto_requisito_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_id)#" index="count">
			<cfscript>
				if(not len(trim(v_id[count]))) {
					this.ins_projeto_requisito(	projeto_id 	= retorno.projeto_id,
												requisito_id = v_requisito_id[count],
												status_id = v_status[count],
												observacao = v_observacao[count],
												tipo_id = v_tipo_id[count],
												tamanho_id = v_tamanho_id[count],
												complexidade_id = v_complexidade_id[count]);
				} else {
					this.upd_projeto_requisito(	projeto_id 	= retorno.projeto_id,
												requisito_id = v_requisito_id[count],
												status_id = v_status[count],
												observacao = v_observacao[count],
												projeto_requisito_id = v_id[count],
												tipo_id = v_tipo_id[count],
												tamanho_id = v_tamanho_id[count],
												complexidade_id = v_complexidade_id[count]);
				}
			</cfscript>
		</cfloop>
		<!--- Ciclo Vida --->
		<cfscript>
			v_tempo = this.ListaToArray (lista = arguments, variavel = "PERC_TEMPO_CICLO_VIDA");
			v_etapa_id = this.ListaToArray (lista = arguments, variavel = "ETAPA_ID_CICLO_VIDA");
			v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CICLO_VIDA, lista2 = ArrayToList(v_etapa_id));
		</cfscript>
		<cfloop list="#v_excluir#" delimiters="," index="l_id">
			<cfscript>
				this.del_projeto_ciclo_vida (projeto_id = retorno.projeto_id,
									   		 etapa_id = l_id);
			</cfscript>
		</cfloop>
		<cfloop from="1" to="#ArrayLen(v_tempo)#" index="count">
			<cfscript>
				this.ins_projeto_ciclo_vida(projeto_id 	= retorno.projeto_id,
											perc_tempo 	= v_tempo[count],
											etapa_id	= v_etapa_id[count]);
			</cfscript>
		</cfloop>
		
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui um projeto
	-- cristofer 02/08/2006 14:50:19 - CRIADO
	--->
	<cffunction name='del_projeto' displayname='Exclui um projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Projeto excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

<!--- 
	-- PROPSITO
	-- Insere uma nova funcao
	-- cristofer 19/05/2006 08:33:26 - CRIADO
	--->
	<cffunction name='ins_recurso_funcao' displayname='Insere uma nova funcao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='RESPONSABILIDADES' required='yes'>
		<cfargument name='COR_HEXADECIMAL' required='yes'>
		<cfargument name='INTERNO' required='no' default='0'>
		<cfargument name='EXTERNO' required='no' default='0'>
		<cfargument name='TERCEIRO' required='no' default='0'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_ins_recurso_funcao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSABILIDADES'  value='#arguments.RESPONSABILIDADES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_HEXADECIMAL' value='#arguments.COR_HEXADECIMAL#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INTERNO' value='#arguments.INTERNO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXTERNO' value='#arguments.EXTERNO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TERCEIRO' value='#arguments.TERCEIRO#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FUNCAO_ID' variable='retorno.FUNCAO_ID'>					
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Funo inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma nova funcao
	-- cristofer 19/05/2006 08:34:37 - CRIADO
	--->
	<cffunction name='upd_recurso_funcao' displayname='Altera uma nova funcao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FUNCAO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='RESPONSABILIDADES' required='yes'>
		<cfargument name='COR_HEXADECIMAL' required='yes'>
		<cfargument name='INTERNO' required='no' default="0">
		<cfargument name='EXTERNO' required='no' default='0'>
		<cfargument name='TERCEIRO' required='no' default='0'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_alt_recurso_funcao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FUNCAO_ID'  value='#arguments.FUNCAO_ID#'  null='#iif(len(trim(arguments.FUNCAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_HEXADECIMAL' value='#arguments.COR_HEXADECIMAL#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INTERNO' value='#arguments.INTERNO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXTERNO' value='#arguments.EXTERNO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TERCEIRO' value='#arguments.TERCEIRO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSABILIDADES'  value='#arguments.RESPONSABILIDADES#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Funo alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma funcao
	-- cristofer 19/05/2006 08:35:14 - CRIADO
	--->
	<cffunction name='del_recurso_funcao' displayname='Exclui uma funcao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FUNCAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_del_recurso_funcao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FUNCAO_ID'  value='#arguments.FUNCAO_ID#'  null='#iif(len(trim(arguments.FUNCAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Funo excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Insere um acronimo/abreviacao no projeto
	-- cristofer 23/08/2006 15:34:07 - CRIADO
	--->
	<cffunction name='ins_projeto_acronimo' displayname='Insere um acronimo/abreviacao no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='ABREVIACAO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_acronimo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ABREVIACAO'  value='#arguments.ABREVIACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ACRONIMO_ID' variable='retorno.ACRONIMO_ID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um acronimo/abreviacao no projeto
	-- cristofer 23/08/2006 15:34:53 - CRIADO
	--->
	<cffunction name='upd_projeto_acronimo' displayname='Altera um acronimo/abreviacao no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ACRONIMO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='ABREVIACAO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_acronimo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ACRONIMO_ID'  value='#arguments.ACRONIMO_ID#'  null='#iif(len(trim(arguments.ACRONIMO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ABREVIACAO'  value='#arguments.ABREVIACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um acronimo/abreviacao no projeto
	-- cristofer 23/08/2006 15:35:19 - CRIADO
	--->
	<cffunction name='del_projeto_acronimo' displayname='Exclui um acronimo/abreviacao no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ACRONIMO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_acronimo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ACRONIMO_ID'  value='#arguments.ACRONIMO_ID#'  null='#iif(len(trim(arguments.ACRONIMO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structNew() />
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Insere um participante do projeto
	-- cristofer 23/08/2006 17:38:11 - CRIADO
	--->
	<cffunction name='ins_projeto_equipe' displayname='Insere um participante do projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='FUNCAO_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='INTERNO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_equipe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FUNCAO_ID'  value='#arguments.FUNCAO_ID#'  null='#iif(len(trim(arguments.FUNCAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INTERNO'  value='#arguments.INTERNO#'  null='#iif(len(trim(arguments.INTERNO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_EQUIPE_ID' variable='retorno.PROJETO_EQUIPE_ID'  >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera um participante do projeto
	-- cristofer 23/08/2006 17:39:08 - CRIADO
	--->
	<cffunction name='upd_projeto_equipe' displayname='Altera um participante do projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_EQUIPE_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='FUNCAO_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='INTERNO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_equipe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_EQUIPE_ID'  value='#arguments.PROJETO_EQUIPE_ID#'  null='#iif(len(trim(arguments.PROJETO_EQUIPE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FUNCAO_ID'  value='#arguments.FUNCAO_ID#'  null='#iif(len(trim(arguments.FUNCAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INTERNO'  value='#arguments.INTERNO#'  null='#iif(len(trim(arguments.INTERNO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um participante do projeto
	-- cristofer 23/08/2006 17:39:33 - CRIADO
	--->
	<cffunction name='del_projeto_equipe' displayname='Exclui um participante do projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_EQUIPE_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_equipe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_EQUIPE_ID'  value='#arguments.PROJETO_EQUIPE_ID#'  null='#iif(len(trim(arguments.PROJETO_EQUIPE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Insere um cronograma no projeto
	-- cristofer 24/08/2006 10:04:36 - CRIADO
	--->
	<cffunction name='ins_projeto_cronograma' displayname='Insere um cronograma no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='RESPONSAVEL' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_cronograma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#'  null='#iif(len(trim(arguments.RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CRONOGRAMA_ID' variable='retorno.CRONOGRAMA_ID'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um cronograma no projeto
	-- cristofer 24/08/2006 10:07:16 - CRIADO
	--->
	<cffunction name='upd_projeto_cronograma' displayname='Altera um cronograma no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CRONOGRAMA_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='RESPONSAVEL' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_cronograma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CRONOGRAMA_ID'  value='#arguments.CRONOGRAMA_ID#'  null='#iif(len(trim(arguments.CRONOGRAMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#'  null='#iif(len(trim(arguments.RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um cronograma no projeto
	-- cristofer 24/08/2006 10:07:54 - CRIADO
	--->
	<cffunction name='del_projeto_cronograma' displayname='Exclui um cronograma no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CRONOGRAMA_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_cronograma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CRONOGRAMA_ID'  value='#arguments.CRONOGRAMA_ID#'  null='#iif(len(trim(arguments.CRONOGRAMA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um recurso no projeto
	-- cristofer 24/08/2006 15:18:51 - CRIADO
	--->
	<cffunction name='ins_projeto_recurso' displayname='Insere um recurso no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='REALIZAR_ATE' required='yes'>
		<cfargument name='CRITERIO_PARTICIPACAO' required='yes'>
		<cfargument name='STATUS' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REALIZAR_ATE'  value='#arguments.REALIZAR_ATE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CRITERIO_PARTICIPACAO'  value='#arguments.CRITERIO_PARTICIPACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS'  value='#arguments.STATUS#'  null='#iif(len(trim(arguments.STATUS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TREINAMENTO_ID' variable='retorno.TREINAMENTO_ID'  >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um recurso no projeto
	-- cristofer 24/08/2006 15:19:54 - CRIADO
	--->
	<cffunction name='upd_projeto_recurso' displayname='Altera um recurso no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TREINAMENTO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='REALIZAR_ATE' required='yes'>
		<cfargument name='CRITERIO_PARTICIPACAO' required='yes'>
		<cfargument name='STATUS' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TREINAMENTO_ID'  value='#arguments.TREINAMENTO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REALIZAR_ATE'  value='#arguments.REALIZAR_ATE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CRITERIO_PARTICIPACAO'  value='#arguments.CRITERIO_PARTICIPACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS'  value='#arguments.STATUS#'  null='#iif(len(trim(arguments.STATUS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um recurso no projeto
	-- cristofer 24/08/2006 15:20:21 - CRIADO
	--->
	<cffunction name='del_projeto_recurso' displayname='Exclui um recurso no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TREINAMENTO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TREINAMENTO_ID'  value='#arguments.TREINAMENTO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um recurso de infra-estrutura no projeto
	-- cristofer 24/08/2006 16:25:07 - CRIADO
	--->
	<cffunction name='ins_projeto_infra_estrutura' displayname='Insere um recurso de infra-estrutura no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='DISPONIBILIZAR_ATE' required='yes'>
		<cfargument name='STATUS' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_infra_estrut' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DISPONIBILIZAR_ATE'  value='#arguments.DISPONIBILIZAR_ATE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS'  value='#arguments.STATUS#'  null='#iif(len(trim(arguments.STATUS)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INFRA_ESTRUTURA_ID' variable='retorno.INFRA_ESTRUTURA_ID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera um recurso de infra-estrutura no projeto
	-- cristofer 24/08/2006 16:28:33 - CRIADO
	--->
	<cffunction name='upd_projeto_infra_estrutura' displayname='Altera um recurso de infra-estrutura no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='INFRA_ESTRUTURA_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='DISPONIBILIZAR_ATE' required='yes'>
		<cfargument name='STATUS' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_infra_estrut' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INFRA_ESTRUTURA_ID'  value='#arguments.INFRA_ESTRUTURA_ID#'  null='#iif(len(trim(arguments.INFRA_ESTRUTURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DISPONIBILIZAR_ATE'  value='#arguments.DISPONIBILIZAR_ATE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS'  value='#arguments.STATUS#'  null='#iif(len(trim(arguments.STATUS)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Exclui um recurso de infra-estrutura no projeto
	-- cristofer 24/08/2006 16:29:11 - CRIADO
	--->
	<cffunction name='del_projeto_infra_estrutura' displayname='Exclui um recurso de infra-estrutura no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='INFRA_ESTRUTURA_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_infra_estrut' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INFRA_ESTRUTURA_ID'  value='#arguments.INFRA_ESTRUTURA_ID#'  null='#iif(len(trim(arguments.INFRA_ESTRUTURA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera os outros recursos do projeto
	-- cristofer 25/08/2006 08:44:54 - CRIADO
	--->
	<cffunction name='upd_projeto_recursos' displayname='Altera os outros recursos do projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_recursos' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#'  null='#iif(len(trim(arguments.DESCRICAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structNew() />
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Insere um risco no projeto
	-- cristofer 25/08/2006 09:54:41 - CRIADO
	--->
	<cffunction name='ins_projeto_risco' displayname='Insere um risco no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='CATEGORIA_ID' required='yes'>
		<cfargument name='PROBABILIDADE_ID' required='yes'>
		<cfargument name='IMPACTO_ID' required='yes'>
		<cfargument name='EXPOSICAO_ID' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cfargument name='ESTRATEGIA' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_risco' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CATEGORIA_ID'  value='#arguments.CATEGORIA_ID#'  null='#iif(len(trim(arguments.CATEGORIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROBABILIDADE_ID'  value='#arguments.PROBABILIDADE_ID#'  null='#iif(len(trim(arguments.PROBABILIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPACTO_ID'  value='#arguments.IMPACTO_ID#'  null='#iif(len(trim(arguments.IMPACTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXPOSICAO_ID'  value='#arguments.EXPOSICAO_ID#'  null='#iif(len(trim(arguments.EXPOSICAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_ESTRATEGIA'  value='#arguments.ESTRATEGIA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RISCO_ID' variable='retorno.RISCO_ID'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera um risco no projeto
	-- cristofer 25/08/2006 09:56:21 - CRIADO
	--->
	<cffunction name='upd_projeto_risco' displayname='Altera um risco no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='RISCO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='CATEGORIA_ID' required='yes'>
		<cfargument name='PROBABILIDADE_ID' required='yes'>
		<cfargument name='IMPACTO_ID' required='yes'>
		<cfargument name='EXPOSICAO_ID' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cfargument name='ESTRATEGIA' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_risco' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RISCO_ID'  value='#arguments.RISCO_ID#'  null='#iif(len(trim(arguments.RISCO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CATEGORIA_ID'  value='#arguments.CATEGORIA_ID#'  null='#iif(len(trim(arguments.CATEGORIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROBABILIDADE_ID'  value='#arguments.PROBABILIDADE_ID#'  null='#iif(len(trim(arguments.PROBABILIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPACTO_ID'  value='#arguments.IMPACTO_ID#'  null='#iif(len(trim(arguments.IMPACTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXPOSICAO_ID'  value='#arguments.EXPOSICAO_ID#'  null='#iif(len(trim(arguments.EXPOSICAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_ESTRATEGIA'  value='#arguments.ESTRATEGIA#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um risco no projeto
	-- cristofer 25/08/2006 09:57:14 - CRIADO
	--->
	<cffunction name='del_projeto_risco' displayname='Exclui um risco no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='RISCO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_risco' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RISCO_ID'  value='#arguments.RISCO_ID#'  null='#iif(len(trim(arguments.RISCO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structNew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um caso de uso no projeto
	-- cristofer 25/08/2006 10:49:03 - CRIADO
	--->
	<cffunction name='ins_projeto_caso_uso' displayname='Insere um caso de uso no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='COMPLEXIDADE_ID' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_caso_uso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPLEXIDADE_ID'  value='#arguments.COMPLEXIDADE_ID#'  null='#iif(len(trim(arguments.COMPLEXIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CASO_USO_ID' variable='retorno.CASO_USO_ID'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um caso de uso no projeto
	-- cristofer 25/08/2006 10:49:47 - CRIADO
	--->
	<cffunction name='upd_projeto_caso_uso' displayname='Altera um caso de uso no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CASO_USO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='COMPLEXIDADE_ID' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_caso_uso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CASO_USO_ID'  value='#arguments.CASO_USO_ID#'  null='#iif(len(trim(arguments.CASO_USO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPLEXIDADE_ID'  value='#arguments.COMPLEXIDADE_ID#'  null='#iif(len(trim(arguments.COMPLEXIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um caso de uso no projeto
	-- cristofer 25/08/2006 10:50:26 - CRIADO
	--->
	<cffunction name='del_projeto_caso_uso' displayname='Exclui um caso de uso no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CASO_USO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_caso_uso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CASO_USO_ID'  value='#arguments.CASO_USO_ID#'  null='#iif(len(trim(arguments.CASO_USO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Insere um ator no projeto
	-- cristofer 25/08/2006 11:47:02 - CRIADO
	--->
	<cffunction name='ins_projeto_ator' displayname='Insere um ator no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='INTERFACE' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_ator' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INTERFACE'  value='#arguments.INTERFACE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATOR_ID' variable='retorno.ATOR_ID'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um ator no projeto
	-- cristofer 25/08/2006 11:47:55 - CRIADO
	--->
	<cffunction name='upd_projeto_ator' displayname='Altera um ator no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATOR_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='INTERFACE' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_ator' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATOR_ID'  value='#arguments.ATOR_ID#'  null='#iif(len(trim(arguments.ATOR_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INTERFACE'  value='#arguments.INTERFACE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structNew() />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui um ator no projeto
	-- cristofer 25/08/2006 11:49:45 - CRIADO
	--->
	<cffunction name='del_projeto_ator' displayname='Exclui um ator no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATOR_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_ator' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATOR_ID'  value='#arguments.ATOR_ID#'  null='#iif(len(trim(arguments.ATOR_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um fator no projeto
	-- cristofer 25/08/2006 14:27:50 - CRIADO
	--->
	<cffunction name='ins_projeto_fator' displayname='Insere um fator no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='FATOR_ID' required='yes'>
		<cfargument name='AVALIACAO' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='JUSTIFICATIVA' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_fator' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FATOR_ID'  value='#arguments.FATOR_ID#'  null='#iif(len(trim(arguments.FATOR_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_AVALIACAO'  value='#arguments.AVALIACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_JUSTIFICATIVA'  value='#arguments.JUSTIFICATIVA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_FATOR_ID' variable='retorno.PROJETO_FATOR_ID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um fator no projeto
	-- cristofer 25/08/2006 14:28:56 - CRIADO
	--->
	<cffunction name='upd_projeto_fator' displayname='Altera um fator no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_FATOR_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='FATOR_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='JUSTIFICATIVA' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_fator' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_FATOR_ID'  value='#arguments.PROJETO_FATOR_ID#'  null='#iif(len(trim(arguments.PROJETO_FATOR_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FATOR_ID'  value='#arguments.FATOR_ID#'  null='#iif(len(trim(arguments.FATOR_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_AVALIACAO'  value='#arguments.AVALIACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_JUSTIFICATIVA'  value='#arguments.JUSTIFICATIVA#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um fator no projeto
	-- cristofer 25/08/2006 14:29:39 - CRIADO
	--->
	<cffunction name='del_projeto_fator' displayname='Exclui um fator no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_FATOR_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_fator' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_FATOR_ID'  value='#arguments.PROJETO_FATOR_ID#'  null='#iif(len(trim(arguments.PROJETO_FATOR_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera as observacoes do projeto
	-- cristofer 28/08/2006 09:18:13 - CRIADO
	--->
	<cffunction name='upd_projeto_observacoes' displayname='Altera as observacoes do projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='PRODUTIVIDADE' required='yes'>
		<cfargument name='IMPRODUTIVIDADE' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_observacoes' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_PRODUTIVIDADE'  value='#arguments.PRODUTIVIDADE#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_IMPRODUTIVIDADE'  value='#arguments.IMPRODUTIVIDADE#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera o escopo do projeto
	-- cristofer 28/08/2006 09:18:13 - CRIADO
	--->
	<cffunction name='upd_projeto_escopo' displayname='Altera as observacoes do projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='ESCOPO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_escopo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_ESCOPO'  value='#arguments.ESCOPO#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Escopo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>				
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera o escopo do projeto
	-- cristofer 28/08/2006 09:18:13 - CRIADO
	--->
	<cffunction name='upd_projeto_limitacao' displayname='Altera as observacoes do projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='LIMITACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_limitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_ESCOPO'  value='#arguments.LIMITACAO#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Limitaes alteradas com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>				
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera o escopo do projeto
	-- cristofer 28/08/2006 09:18:13 - CRIADO
	--->
	<cffunction name='upd_projeto_meta' displayname='Altera as observacoes do projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='META' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_meta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_ESCOPO'  value='#arguments.META#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Metas alteradas com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>				
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Insere um requisito no projeto
	-- cristofer 28/08/2006 11:57:29 - CRIADO
	--->
	<cffunction name='ins_projeto_requisito' displayname='Insere um requisito no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='REQUISITO_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='COMPLEXIDADE_ID' required='yes'>
		<cfargument name='TAMANHO_ID' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPLEXIDADE_ID'  value='#arguments.COMPLEXIDADE_ID#'  null='#iif(len(trim(arguments.COMPLEXIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAMANHO_ID'  value='#arguments.TAMANHO_ID#'  null='#iif(len(trim(arguments.TAMANHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_REQUISITO_ID' variable='retorno.PROJETO_REQUISITO_ID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um requisito no projeto
	-- cristofer 28/08/2006 11:58:16 - CRIADO
	--->
	<cffunction name='upd_projeto_requisito' displayname='Altera um requisito no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_REQUISITO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='REQUISITO_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='COMPLEXIDADE_ID' required='yes'>
		<cfargument name='TAMANHO_ID' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_REQUISITO_ID'  value='#arguments.PROJETO_REQUISITO_ID#'  null='#iif(len(trim(arguments.PROJETO_REQUISITO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPLEXIDADE_ID'  value='#arguments.COMPLEXIDADE_ID#'  null='#iif(len(trim(arguments.COMPLEXIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAMANHO_ID'  value='#arguments.TAMANHO_ID#'  null='#iif(len(trim(arguments.TAMANHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um requisito no projeto
	-- cristofer 28/08/2006 11:58:54 - CRIADO
	--->
	<cffunction name='del_projeto_requisito' displayname='Exclui um requisito no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_REQUISITO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_REQUISITO_ID'  value='#arguments.PROJETO_REQUISITO_ID#'  null='#iif(len(trim(arguments.PROJETO_REQUISITO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Insere um vinculo entre requisitos
	-- cristofer 29/08/2006 15:34:47 - CRIADO
	--->
	<cffunction name='ins_projeto_req_vinculo' displayname='Insere um vinculo entre requisitos' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='REQUISITO_ID_1' required='yes'>
		<cfargument name='REQUISITO_ID_2' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_req_vinculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID_1'  value='#arguments.REQUISITO_ID_1#'  null='#iif(len(trim(arguments.REQUISITO_ID_1)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID_2'  value='#arguments.REQUISITO_ID_2#'  null='#iif(len(trim(arguments.REQUISITO_ID_2)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Requisito vinculado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um vinculo entre requisitos
	-- cristofer 29/08/2006 15:35:44 - CRIADO
	--->
	<cffunction name='del_projeto_req_vinculo' displayname='Exclui um vinculo entre requisitos' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='REQUISITO_ID_1' required='yes'>
		<cfargument name='REQUISITO_ID_2' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_req_vinculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID_1'  value='#arguments.REQUISITO_ID_1#'  null='#iif(len(trim(arguments.REQUISITO_ID_1)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID_2'  value='#arguments.REQUISITO_ID_2#'  null='#iif(len(trim(arguments.REQUISITO_ID_2)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Requisito excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere os valores para a etapa do ciclo de vida no projeto
	-- cristofer 08/09/2006 10:58:05 - CRIADO
	--->
	<cffunction name='ins_projeto_ciclo_vida' displayname='Insere os valores para a etapa do ciclo de vida no projeto' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='ETAPA_ID' required='yes'>
		<cfargument name='NUM_ETAPA' required='yes'>
		<cfargument name='PERC_TEMPO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_ciclo_vida' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ETAPA'  value='#arguments.NUM_ETAPA#'  null='#iif(len(trim(arguments.NUM_ETAPA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERC_TEMPO'  value='#arguments.PERC_TEMPO#'  null='#iif(len(trim(arguments.PERC_TEMPO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui os valores para a etapa do ciclo de vida no projeto
	-- cristofer 08/09/2006 10:58:05 - CRIADO
	--->
	<cffunction name='del_projeto_ciclo_vida' displayname='Exclui os valores para a etapa do ciclo de vida no projeto' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='ETAPA_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_ciclo_vida' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere requisito
	-- guto 03/07/2006 09:15:06 - CRIADO
	--->
	<cffunction name='ins_requisito' displayname='Insere requisito' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REQUISITO_PAI' required='no' default="">
		<cfargument name='COD_REQUISITO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='ESCOPO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='ESTADO_ID' required='yes'>
		<cfargument name='REQUISITO_DEPENDE_VINCULADO' required='no' default="">
		<cfargument name='REQUISITO_AFETA_VINCULADO' required='no' default="">
		<cfargument name="FUNCIONAL" required="no" default="1">
		<cftry>
			<cftransaction action='begin'>
				<cfif arguments.requisito_pai eq 0>
					<cfset arguments.requisito_pai = ''>
				</cfif>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_ins_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_PAI'  value='#arguments.REQUISITO_PAI#'  null='#iif(len(trim(arguments.REQUISITO_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_REQUISITO'  value='#arguments.COD_REQUISITO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_CLOB'  dbvarname='P_ESCOPO'  value='#arguments.ESCOPO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTADO_ID'  value='#arguments.ESTADO_ID#'  null='#iif(len(trim(arguments.ESTADO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FUNCIONAL'  value='#arguments.FUNCIONAL#'  null='#iif(len(trim(arguments.FUNCIONAL)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#' variable='retorno.REQUISITO_ID'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				
				<!---Cria vinculos --->
				<cfloop list="#arguments.REQUISITO_DEPENDE_VINCULADO#" index="i">
					<cfscript>
						this.ins_requisito_vinculo_private(requisito_id_1 = i,
						                           requisito_id_2 = retorno.REQUISITO_ID);
					</cfscript>
				</cfloop>
				<cfloop list="#arguments.REQUISITO_AFETA_VINCULADO#" index="i">
					<cfscript>
						this.ins_requisito_vinculo_private(requisito_id_1 = retorno.REQUISITO_ID,
						                           requisito_id_2 = i);
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Requisito inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera requisito
	-- guto 03/07/2006 09:15:54 - CRIADO
	--->
	<cffunction name='upd_requisito' displayname='Altera requisito' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REQUISITO_ID' required='yes'>
		<cfargument name='REQUISITO_PAI' required='yes'>
		<cfargument name='COD_REQUISITO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='ESCOPO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='ESTADO_ID' required='yes'>
		<cfargument name='REQUISITO_DEPENDE_VINCULADO' required='no' default="">
		<cfargument name='REQUISITO_AFETA_VINCULADO' required='no' default="">
		<cfargument name="FUNCIONAL" required="no" default="1">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_alt_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_REQUISITO'  value='#arguments.COD_REQUISITO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_PAI'  value='#arguments.REQUISITO_PAI#'  null='#iif(len(trim(arguments.REQUISITO_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_CLOB' dbvarname='P_ESCOPO'  value='#arguments.ESCOPO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTADO_ID'  value='#arguments.ESTADO_ID#'  null='#iif(len(trim(arguments.ESTADO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FUNCIONAL'  value='#arguments.FUNCIONAL#'  null='#iif(len(trim(arguments.FUNCIONAL)), de('no'), de('yes'))#'>
				</cfstoredproc>

				<!---Limpa vinculos --->
					<cfscript>
						this.del_all_requisito_vinculo(requisito_id = arguments.REQUISITO_ID);
					</cfscript>				
				<!---Cria vinculos --->
				<cfloop list="#arguments.REQUISITO_DEPENDE_VINCULADO#" index="i">
					<cfscript>
						this.ins_requisito_vinculo_private(requisito_id_1 = i,
						                           requisito_id_2 = arguments.REQUISITO_ID);
					</cfscript>
				</cfloop>
				<cfloop list="#arguments.REQUISITO_AFETA_VINCULADO#" index="i">
					<cfscript>
						this.ins_requisito_vinculo_private(requisito_id_1 = arguments.REQUISITO_ID,
						                           requisito_id_2 = i);
					</cfscript>
				</cfloop>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Requisito alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui requisito
	-- guto 03/07/2006 09:16:47 - CRIADO
	--->
	<cffunction name='del_requisito' displayname='Exclui requisito' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REQUISITO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_del_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Requisito excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Insere um novo vinculo entre requisitos (PRIVATE)
	-- guto 03/07/2006 16:26:05 - CRIADO
	--->
	<cffunction name='ins_requisito_vinculo_private' displayname='Insere um novo vinculo entre requisitos' access='remote'>;
		<cfargument name='REQUISITO_ID_1' required='yes'>
		<cfargument name='REQUISITO_ID_2' required='yes'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_ins_requisito_vinculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID_1'  value='#arguments.REQUISITO_ID_1#'  null='#iif(len(trim(arguments.REQUISITO_ID_1)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID_2'  value='#arguments.REQUISITO_ID_2#'  null='#iif(len(trim(arguments.REQUISITO_ID_2)), de('no'), de('yes'))#'>
				</cfstoredproc>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um novo vinculo entre requisitos
	-- guto 03/07/2006 16:26:05 - CRIADO
	--->
	<cffunction name='ins_requisito_vinculo' displayname='Insere um novo vinculo entre requisitos' access='remote' returntype="struct">;
		<cfargument name='REQUISITO_ID_1' required='yes'>
		<cfargument name='REQUISITO_ID_2' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_ins_requisito_vinculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID_1'  value='#arguments.REQUISITO_ID_1#'  null='#iif(len(trim(arguments.REQUISITO_ID_1)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID_2'  value='#arguments.REQUISITO_ID_2#'  null='#iif(len(trim(arguments.REQUISITO_ID_2)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui vinculo entre requisitos
	-- guto 03/07/2006 16:26:48 - CRIADO
	--->
	<cffunction name='del_requisito_vinculo' displayname='Exclui vinculo entre requisitos' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REQUISITO_ID_1' required='yes'>
		<cfargument name='REQUISITO_ID_2' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_del_requisito_vinculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID_1'  value='#arguments.REQUISITO_ID_1#'  null='#iif(len(trim(arguments.REQUISITO_ID_1)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID_2'  value='#arguments.REQUISITO_ID_2#'  null='#iif(len(trim(arguments.REQUISITO_ID_2)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui todos os vinculos do requisito
	-- guto 03/07/2006 16:27:26 - CRIADO
	--->
	<cffunction name='del_all_requisito_vinculo' displayname='Exclui todos os vinculos do requisito' access='remote' output='false'>;
		<cfargument name='REQUISITO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_del_all_requisito_vinculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Insere uma nova etapa no ciclo de vida
	-- cristofer 12/09/2006 11:15:43 - CRIADO
	--->
	<cffunction name='ins_ciclo_vida_etapa' displayname='Insere uma nova etapa no ciclo de vida' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ETAPA' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='PERC_TEMPO' required='yes'>
		<cfargument name='PADRAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_ins_ciclo_vida_etapa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ETAPA'  value='#arguments.NUM_ETAPA#'  null='#iif(len(trim(arguments.NUM_ETAPA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERC_TEMPO'  value='#arguments.PERC_TEMPO#'  null='#iif(len(trim(arguments.PERC_TEMPO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PADRAO'  value='#arguments.PADRAO#'  null='#iif(len(trim(arguments.PADRAO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ETAPA_ID' variable='retorno.ETAPA_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Etapa inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um etapa no ciclo de vida
	-- cristofer 12/09/2006 11:16:42 - CRIADO
	--->
	<cffunction name='upd_ciclo_vida_etapa' displayname='Altera um etapa no ciclo de vida' access='remote' returntype='Struct' output='true'>
		<cfargument name='ETAPA_ID' required='yes'>
		<cfargument name='NUM_ETAPA' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='PERC_TEMPO' required='yes'>
		<cfargument name='PADRAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_alt_ciclo_vida_etapa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ETAPA'  value='#arguments.NUM_ETAPA#'  null='#iif(len(trim(arguments.NUM_ETAPA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERC_TEMPO'  value='#arguments.PERC_TEMPO#'  null='#iif(len(trim(arguments.PERC_TEMPO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PADRAO'  value='#arguments.PADRAO#'  null='#iif(len(trim(arguments.PADRAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Etapa alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um etapa no ciclo de vida
	-- cristofer 12/09/2006 11:24:52 - CRIADO
	--->
	<cffunction name='del_ciclo_vida_etapa' displayname='Exclui um etapa no ciclo de vida' access='remote' returntype='Struct' output='true'>
		<cfargument name='ETAPA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_del_ciclo_vida_etapa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Etapa excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere uma tarefa
	-- cristofer 13/09/2006 10:46:28 - CRIADO
	--->
	<cffunction name='ins_tarefa' displayname='Insere uma tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='TIPO_APLICACAO_ID' required='yes'>
		<cfargument name='SD_DETALHAMENTO_ID' required='yes'>
		<cfargument name='CONTATO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='URGENCIA_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='TAREFA_PAI' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_ins_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SD_DETALHAMENTO_ID'  value='#arguments.SD_DETALHAMENTO_ID#'  null='#iif(len(trim(arguments.SD_DETALHAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_APLICACAO_ID'  value='#arguments.TIPO_APLICACAO_ID#'  null='#iif(len(trim(arguments.TIPO_APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTATO'  value='#arguments.CONTATO#'  null='#iif(len(trim(arguments.CONTATO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_URGENCIA_ID'  value='#arguments.URGENCIA_ID#'  null='#iif(len(trim(arguments.URGENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_PAI'  value='#arguments.TAREFA_PAI#'  null='#iif(len(trim(arguments.TAREFA_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID' variable='retorno.TAREFA_ID' >
				</cfstoredproc>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa #NumberFormat(retorno.tarefa_id,'0')# inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma tarefa
	-- cristofer 13/09/2006 10:47:39 - CRIADO
	--->
	<cffunction name='upd_tarefa' displayname='Altera uma tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='APLICACAO_ID' required='yes'>
		<cfargument name='TIPO_APLICACAO_ID' required='yes'>
		<cfargument name='SD_DETALHAMENTO_ID' required='no' default="">
		<cfargument name='CONTATO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='URGENCIA_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ENTREGAR_EM' required='yes'>
		<cfargument name='TAREFA_PAI' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_alt_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SD_DETALHAMENTO_ID'  value='#arguments.SD_DETALHAMENTO_ID#'  null='#iif(len(trim(arguments.SD_DETALHAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_APLICACAO_ID'  value='#arguments.TIPO_APLICACAO_ID#'  null='#iif(len(trim(arguments.TIPO_APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTATO'  value='#arguments.CONTATO#'  null='#iif(len(trim(arguments.CONTATO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_URGENCIA_ID'  value='#arguments.URGENCIA_ID#'  null='#iif(len(trim(arguments.URGENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_PAI'  value='#arguments.TAREFA_PAI#'  null='#iif(len(trim(arguments.TAREFA_PAI)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					retorno.tarefa_id = arguments.tarefa_id;
				</cfscript>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma dependencia entre tarefas
	-- cristofer 14/09/2006 11:07:29 - CRIADO
	--->
	<cffunction name='ins_tarefa_dependencia' displayname='Insere uma dependencia entre tarefas' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='TAREFA_ID_DEPENDENCIA' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_ins_tarefa_dependencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID_DEPENDENCIA'  value='#arguments.TAREFA_ID_DEPENDENCIA#'  null='#iif(len(trim(arguments.TAREFA_ID_DEPENDENCIA)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma dependencia entre tarefas
	-- cristofer 14/09/2006 11:07:51 - CRIADO
	--->
	<cffunction name='del_tarefa_dependencia' displayname='Exclui uma dependencia entre tarefas' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='TAREFA_ID_DEPENDENCIA' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_del_tarefa_dependencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID_DEPENDENCIA'  value='#arguments.TAREFA_ID_DEPENDENCIA#'  null='#iif(len(trim(arguments.TAREFA_ID_DEPENDENCIA)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Atribui a tarefa a um tecnico
	-- cristofer 14/09/2006 13:48:35 - CRIADO
	--->
	<cffunction name='atribui_tarefa' displayname='Atribui a tarefa a um tecnico' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_atribui_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUICAO_ID' variable='retorno.ATRIBUICAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa atribuida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Transfere a tarefa a outro tecnico
	-- cristofer 14/09/2006 13:49:14 - CRIADO
	--->
	<cffunction name='transfere_tarefa' displayname='Transfere a tarefa a outro tecnico' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='HORAS_EXECUCAO' required='no' default="0">
		<cfargument name='MINUTOS_EXECUCAO' required='no' default="0">
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cfscript>
				checklist = this.verifica_tarefa(argumentCollection = arguments);
			</cfscript>
			<cfif checklist.erro>
				<cfthrow object="#checklist.mensagem#">
			</cfif>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_transfere_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORAS_EXECUCAO'  value='#arguments.HORAS_EXECUCAO#'  null='#iif(len(trim(arguments.HORAS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MINUTOS_EXECUCAO'  value='#arguments.MINUTOS_EXECUCAO#'  null='#iif(len(trim(arguments.MINUTOS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUICAO_ID' variable='retorno.ATRIBUICAO_ID' >
				</cfstoredproc>
					<cfscript>
						retorno.tarefa_id = arguments.tarefa_id;
						v_checklist_id = this.ListaToArray (lista = arguments, variavel = "CHECKLIST_ID_NEW_CHECKLIST");
						v_pergunta_id = this.ListaToArray (lista = arguments, variavel = "PERGUNTA_ID_CHECKLIST");
						v_pergunta = this.ListaToArray (lista = arguments, variavel = "PERGUNTA_CHECKLIST");
						v_comentario = this.ListaToArray (lista = arguments, variavel = "COMENTARIO_CHECKLIST_CHECKLIST");
					</cfscript>
					<cfloop from="1" to="#ArrayLen(v_checklist_id)#" index="count">
						<cfscript>
							if( not len(trim(v_checklist_id[count]))) {
								this.ins_tarefa_checklist(tarefa_id 	= retorno.tarefa_id,
															pergunta	= v_pergunta[count],
															comentario	= v_comentario[count]);
							} else {
								this.upd_tarefa_checklist(tarefa_id 	= retorno.tarefa_id,
															pergunta	= v_pergunta[count],
															comentario	= v_comentario[count],
															checklist_id = v_checklist_id[count]);
							}
						</cfscript>
					</cfloop>
										
					<cfscript>
						v_arquivo_id = this.ListaToArray (lista = arguments, variavel = "ARQUIVO_ID_ARQUIVOS");
						v_nome = this.ListaToArray (lista = arguments, variavel = "ARQUIVO_NOME_ARQUIVOS");
						v_caminho = this.ListaToArray (lista = arguments, variavel = "ARQUIVO_CAMINHO_ARQUIVOS");
						v_comentario = this.ListaToArray (lista = arguments, variavel = "COMENTARIO_ARQUIVO_ARQUIVOS");
						conn = CreateObject("component", "_transportes.consulta.cfc_kmm");
						qrArquivo = conn.get_tarefa_arquivo(tarefa_id = retorno.tarefa_id);
					</cfscript>
					<cfoutput query="qrArquivo">
						<cfif not ListFind(ArrayToList(v_arquivo_id), qrArquivo.arquivo_id)>
							<cfscript>
								this.del_tarefa_arquivo(arquivo_id = qrArquivo.arquivo_id,
														tarefa_id = retorno.tarefa_id);
							</cfscript>
						</cfif>
					</cfoutput>
					<cfloop from="1" to="#ArrayLen(v_arquivo_id)#" index="count">
						<cfscript>
								res = this.ins_arquivo_caminho(   caminho		= v_caminho[count],
															nome		= v_nome[count],
															comentario	= v_comentario[count]);
								this.ins_tarefa_arquivo (tarefa_id = retorno.tarefa_id,
														 arquivo_id = res.arquivo_id);
						</cfscript>
					</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa transferida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Inicia a execuo de uma tarefa
	-- cristofer 14/09/2006 15:49:15 - CRIADO
	--->
	<cffunction name='executar_tarefa' displayname='Inicia a execuo de uma tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_iniciar_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Execuo iniciada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Para a execuo de uma tarefa
	-- cristofer 14/09/2006 15:49:55 - CRIADO
	--->
	<cffunction name='parar_tarefa' displayname='Para a execuo de uma tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='HORAS_EXECUCAO' required='yes'>
		<cfargument name='MINUTOS_EXECUCAO' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_parar_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORAS_EXECUCAO'  value='#arguments.HORAS_EXECUCAO#'  null='#iif(len(trim(arguments.HORAS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MINUTOS_EXECUCAO'  value='#arguments.MINUTOS_EXECUCAO#'  null='#iif(len(trim(arguments.MINUTOS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Execuo parada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Libera uma tarefa para teste
	-- cristofer 14/09/2006 18:01:41 - CRIADO
	--->
	<cffunction name='libera_teste_tarefa' displayname='Libera uma tarefa para teste' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cfargument name='HORAS_EXECUCAO' required='yes'>
		<cfargument name='MINUTOS_EXECUCAO' required='yes'>
		<cftry>
			<cfscript>
				checklist = this.verifica_tarefa(argumentCollection = arguments);
			</cfscript>
			<cfif checklist.erro>
				<cfthrow object="#checklist.mensagem#">
			</cfif>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_libera_teste_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORAS_EXECUCAO'  value='#arguments.HORAS_EXECUCAO#'  null='#iif(len(trim(arguments.HORAS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MINUTOS_EXECUCAO'  value='#arguments.MINUTOS_EXECUCAO#'  null='#iif(len(trim(arguments.MINUTOS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUICAO_ID' variable='retorno.ATRIBUICAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa liberada para teste com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Testa a execuo de uma tarefa
	-- cristofer 14/09/2006 15:49:15 - CRIADO
	--->
	<cffunction name='testar_tarefa' displayname='Testa a execuo de uma tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_testar_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Testes iniciados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- Para a execuo de uma tarefa
	-- cristofer 14/09/2006 15:49:55 - CRIADO
	--->
	<cffunction name='parar_teste_tarefa' displayname='Para a execuo de uma tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='HORAS_EXECUCAO' required='yes'>
		<cfargument name='MINUTOS_EXECUCAO' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_parar_teste_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORAS_EXECUCAO'  value='#arguments.HORAS_EXECUCAO#'  null='#iif(len(trim(arguments.HORAS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MINUTOS_EXECUCAO'  value='#arguments.MINUTOS_EXECUCAO#'  null='#iif(len(trim(arguments.MINUTOS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Testes parados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Recusa uma tarefa 
	-- cristofer 14/09/2006 18:01:41 - CRIADO
	--->
	<cffunction name='recusar_tarefa' displayname='Recusa uma tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cfargument name='HORAS_EXECUCAO' required='yes'>
		<cfargument name='MINUTOS_EXECUCAO' required='yes'>
		<cftry>
			<cfscript>
				checklist = this.verifica_tarefa(argumentCollection = arguments, teste = 1);
			</cfscript>
			<cfif checklist.erro>
				<cfthrow object="#checklist.mensagem#">
			</cfif>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_recusar_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORAS_EXECUCAO'  value='#arguments.HORAS_EXECUCAO#'  null='#iif(len(trim(arguments.HORAS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MINUTOS_EXECUCAO'  value='#arguments.MINUTOS_EXECUCAO#'  null='#iif(len(trim(arguments.MINUTOS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUICAO_ID' variable='retorno.ATRIBUICAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa recusada com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Coloca uma tarefa em modo aguardando
	-- cristofer 14/09/2006 15:49:15 - CRIADO
	--->
	<cffunction name='aguardar_tarefa' displayname='Coloca uma tarefa em modo aguardando' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_aguardar_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa marcada como aguardando definio com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Libera uma tarefa para teste
	-- cristofer 14/09/2006 18:01:41 - CRIADO
	--->
	<cffunction name='libera_atualizacao_tarefa' displayname='Libera uma tarefa para teste' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cfargument name='HORAS_EXECUCAO' required='yes'>
		<cfargument name='MINUTOS_EXECUCAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_liberar_atualizacao_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORAS_EXECUCAO'  value='#arguments.HORAS_EXECUCAO#'  null='#iif(len(trim(arguments.HORAS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MINUTOS_EXECUCAO'  value='#arguments.MINUTOS_EXECUCAO#'  null='#iif(len(trim(arguments.MINUTOS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUICAO_ID' variable='retorno.ATRIBUICAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa liberada para atualizao com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Coloca uma tarefa em modo aguardando
	-- cristofer 14/09/2006 15:49:15 - CRIADO
	--->
	<cffunction name='rejeitar_tarefa' displayname='Coloca uma tarefa em modo aguardando' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_rejeitar_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa rejeitada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Libera uma tarefa para teste
	-- cristofer 14/09/2006 18:01:41 - CRIADO
	--->
	<cffunction name='finaliza_tarefa' displayname='Libera uma tarefa para teste' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cfargument name='HORAS_EXECUCAO' required='yes'>
		<cfargument name='MINUTOS_EXECUCAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_finalizar_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORAS_EXECUCAO'  value='#arguments.HORAS_EXECUCAO#'  null='#iif(len(trim(arguments.HORAS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MINUTOS_EXECUCAO'  value='#arguments.MINUTOS_EXECUCAO#'  null='#iif(len(trim(arguments.MINUTOS_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUICAO_ID' variable='retorno.ATRIBUICAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa finalizada com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere uma ocorrencia para a tarefa
	-- cristofer 18/09/2006 18:01:41 - CRIADO
	--->
	<cffunction name='ins_tarefa_ocorrencia' displayname='Insere uma ocorrencia para a tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cfargument name='OCORRENCIA_TIPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_ins_tarefa_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_TIPO_ID'  value='#arguments.OCORRENCIA_TIPO_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OCORRENCIA'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_ID' variable='retorno.OCORRENCIA_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ocorrencia inserida com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>		
		
	<!--- 
	-- PROPSITO
	-- Insere uma pergunta na tarefa
	-- cristofer 18/09/2006 10:03:13 - CRIADO
	--->
	<cffunction name='ins_tarefa_checklist' displayname='Insere uma pergunta na tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='PERGUNTA' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_ins_tarefa_checklist' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PERGUNTA'  value='#arguments.PERGUNTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERGUNTA_ID' variable='retorno.PERGUNTA_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CHECKLIST_ID' variable='retorno.CHECKLIST_ID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma pergunta na tarefa
	-- cristofer 18/09/2006 10:03:48 - CRIADO
	--->
	<cffunction name='upd_tarefa_checklist' displayname='Altera uma pergunta na tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='CHECKLIST_ID' required='yes'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='PERGUNTA' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_alt_tarefa_checklist' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CHECKLIST_ID'  value='#arguments.CHECKLIST_ID#'  null='#iif(len(trim(arguments.CHECKLIST_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PERGUNTA'  value='#arguments.PERGUNTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERGUNTA_ID' variable='retorno.PERGUNTA_ID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma pergunta na tarefa
	-- cristofer 18/09/2006 10:04:12 - CRIADO
	--->
	<cffunction name='del_tarefa_checklist' displayname='Exclui uma pergunta na tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='CHECKLIST_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_del_tarefa_checklist' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CHECKLIST_ID'  value='#arguments.CHECKLIST_ID#'  null='#iif(len(trim(arguments.CHECKLIST_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Verifica uma questao da checklist
	-- cristofer 18/09/2006 10:03:48 - CRIADO
	--->
	<cffunction name='verifica_checklist' displayname=' Verifica uma questao da checklist' access='remote' returntype='Struct' output='true'>
		<cfargument name='CHECKLIST_ID' required='yes'>
		<cfargument name='ATRIBUICAO_ID' required='yes'>
		<cfargument name='VERIFICADO' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_verifica_checklist' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CHECKLIST_ID'  value='#arguments.CHECKLIST_ID#'  null='#iif(len(trim(arguments.CHECKLIST_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUICAO_ID'  value='#arguments.ATRIBUICAO_ID#'  null='#iif(len(trim(arguments.ATRIBUICAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERIFICADO'  value='#arguments.VERIFICADO#'  null='#iif(len(trim(arguments.VERIFICADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma ocorrencia para a tarefa
	-- cristofer 18/09/2006 18:01:41 - CRIADO
	--->
	<cffunction name='verifica_tarefa' displayname='Insere uma ocorrencia para a tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='CHECKLIST_ID' required='no' default="">
		<cfargument name='ATRIBUICAO_ID' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfloop list="#arguments.CHECKLIST_ID#" index="l_id">
					<cfscript>
						this.verifica_checklist(checklist_id = l_id,
												atribuicao_id = arguments.atribuicao_id,
												verificado = arguments["CHECKLIST_VERIFICADO_"&l_id],
												comentario = arguments["COMENTARIO_#l_id#"]);
					</cfscript>
					
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Checklist atualizado com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera os parametros de requisito do projeto
	-- cristofer 21/09/2006 18:01:41 - CRIADO
	--->
	<cffunction name='set_projeto_custo' displayname='Altera os parametros de requisito do projeto' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='TOTAL_PRODUTIVIDADE' required='yes'>
		<cfargument name='HORAS_MES' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_set_projeto_custo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TOTAL_PRODUTIVIDADE'  value='#arguments.TOTAL_PRODUTIVIDADE#'  null='#iif(len(trim(arguments.TOTAL_PRODUTIVIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORAS_MES'  value='#arguments.HORAS_MES#'  null='#iif(len(trim(arguments.HORAS_MES)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pontos salvos com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
			
	
	<!--- 
	-- PROPSITO
	-- Insere um custo complementar ao projeto
	-- cristofer 21/09/2006 10:03:48 - CRIADO
	--->
	<cffunction name='ins_projeto_custo_complementar' displayname='Insere um custo complementar ao projeto' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='VALOR' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_custo_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REALIZACAO'  value='#arguments.REALIZACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTIMADO'  value='#arguments.ESTIMADO#'  null='#iif(len(trim(arguments.ESTIMADO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID' variable="retorno.ITEM_ID">
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera um custo complementar ao projeto
	-- cristofer 21/09/2006 10:03:48 - CRIADO
	--->
	<cffunction name='upd_projeto_custo_complementar' displayname='Altera um custo complementar ao projeto' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='VALOR' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_custo_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REALIZACAO'  value='#arguments.REALIZACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTIMADO'  value='#arguments.ESTIMADO#'  null='#iif(len(trim(arguments.ESTIMADO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere uma etapa na tarefa
	-- cristofer 22/09/2006 10:03:48 - CRIADO
	--->
	<cffunction name='ins_tarefa_etapa' displayname='Insere uma etapa na tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='ETAPA_ID' required='yes'>
		<cfargument name='DATA_LIMITE' required='yes'>
		<cfargument name='HORAS_ESTIMADO' required='yes'>
		<cfargument name='MINUTOS_ESTIMADO' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_ins_tarefa_etapa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_DATA_LIMITE'  value='#arguments.DATA_LIMITE#'  null='#iif(len(trim(arguments.DATA_LIMITE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORAS_ESTIMADO'  value='#arguments.HORAS_ESTIMADO#'  null='#iif(len(trim(arguments.HORAS_ESTIMADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MINUTOS_ESTIMADO'  value='#arguments.MINUTOS_ESTIMADO#'  null='#iif(len(trim(arguments.MINUTOS_ESTIMADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Exclui uma etapa na tarefa
	-- cristofer 22/09/2006 10:03:48 - CRIADO
	--->
	<cffunction name='del_tarefa_etapa' displayname='Exclui uma etapa na tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='ETAPA_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_del_tarefa_etapa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Exclui um custo complementar ao projeto
	-- cristofer 21/09/2006 10:03:48 - CRIADO
	--->
	<cffunction name='del_projeto_custo_complementar' displayname='Exclui um custo complementar ao projeto' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_custo_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um planejamento de reuniao
	-- cristofer 26/09/2006 14:21:01 - CRIADO
	--->
	<cffunction name='ins_projeto_reuniao_planejamento' displayname='Insere um planejamento de reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_reuniao_plan' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLANEJAMENTO_ID' variable='retorno.PLANEJAMENTO_ID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um planejamento de reuniao
	-- cristofer 26/09/2006 14:22:38 - CRIADO
	--->
	<cffunction name='upd_projeto_reuniao_planejamento' displayname='Altera um planejamento de reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLANEJAMENTO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_reuniao_plan' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLANEJAMENTO_ID'  value='#arguments.PLANEJAMENTO_ID#'  null='#iif(len(trim(arguments.PLANEJAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um planejamento de reuniao
	-- cristofer 26/09/2006 14:23:11 - CRIADO
	--->
	<cffunction name='del_projeto_reuniao_planejamento' displayname='Exclui um planejamento de reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLANEJAMENTO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_reuniao_plan' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLANEJAMENTO_ID'  value='#arguments.PLANEJAMENTO_ID#'  null='#iif(len(trim(arguments.PLANEJAMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma reuniao
	-- cristofer 26/09/2006 17:05:01 - CRIADO
	--->
	<cffunction name='ins_reuniao' displayname='Insere uma reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='LOCAL' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_ins_reuniao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LOCAL'  value='#arguments.LOCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REUNIAO_ID' variable='retorno.REUNIAO_ID' >
				</cfstoredproc>

				<!--- Participantes --->
				<cfscript>
					arguments.reuniao_id = retorno.reuniao_id;
					this.upd_reuniao_anexos_private(argumentCollection = arguments);
					v_participante_id = this.ListaToArray (lista = arguments, variavel = "PARTICIPANTE_ID_PARTICIPANTES");
					v_recurso_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_PARTICIPANTES");
					v_observacao = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_PARTICIPANTE_PARTICIPANTES");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_PARTICIPANTES, lista2 = ArrayToList(v_participante_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_reuniao_participante (reuniao_id = retorno.reuniao_id,
												 	   participante_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_participante_id)#" index="count">
					<cfscript>
						if(not len(trim(v_participante_id[count]))) {
							this.ins_reuniao_participante(	reuniao_id 	= retorno.reuniao_id,
															recurso_id	= v_recurso_id[count],
															observacao	= v_observacao[count]);
						} else {
							this.upd_reuniao_participante(	reuniao_id 	= retorno.reuniao_id,
															recurso_id	= v_recurso_id[count],
															observacao	= v_observacao[count],
															participante_id = v_participante_id[count]);
						}
					</cfscript>
				</cfloop>
				<!--- Assuntos --->
				<cfscript>
					v_assunto_id = this.ListaToArray (lista = arguments, variavel = "ASSUNTO_ID_ASSUNTOS");
					v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_ASSUNTO_ASSUNTOS");
					v_conclusao = this.ListaToArray (lista = arguments, variavel = "CONCLUSAO_ASSUNTO_ASSUNTOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ASSUNTOS, lista2 = ArrayToList(v_assunto_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_reuniao_assunto (reuniao_id = retorno.reuniao_id,
												assunto_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_assunto_id)#" index="count">
					<cfscript>
						if(not len(trim(v_assunto_id[count]))) {
							this.ins_reuniao_assunto(	reuniao_id 	= retorno.reuniao_id,
														descricao	= v_descricao[count],
														conclusao 	= v_conclusao[count]);
						} else {
							this.upd_reuniao_assunto(	reuniao_id 	= retorno.reuniao_id,
														descricao	= v_descricao[count],
														conclusao	= v_conclusao[count],
														assunto_id	= v_assunto_id[count]);
						}
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Reuniao inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma reuniao
	-- cristofer 26/09/2006 17:05:43 - CRIADO
	--->
	<cffunction name='upd_reuniao' displayname='Altera uma reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='REUNIAO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='LOCAL' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cfargument name='INICIO' required='yes'>
		<cfargument name='TERMINO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_alt_reuniao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REUNIAO_ID'  value='#arguments.REUNIAO_ID#'  null='#iif(len(trim(arguments.REUNIAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LOCAL'  value='#arguments.LOCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INICIO'  value='#arguments.INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TERMINO'  value='#arguments.TERMINO#' >
				</cfstoredproc>
				<!--- Participantes --->
				<cfscript>
					retorno.reuniao_id = arguments.reuniao_id;
					this.upd_reuniao_anexos_private(argumentCollection = arguments);


					v_participante_id = this.ListaToArray (lista = arguments, variavel = "PARTICIPANTE_ID_PARTICIPANTES");
					v_recurso_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_PARTICIPANTES");
					v_observacao = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_PARTICIPANTE_PARTICIPANTES");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_PARTICIPANTES, lista2 = ArrayToList(v_participante_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_reuniao_participante (participante_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_participante_id)#" index="count">
					<cfscript>
						if(not len(trim(v_participante_id[count]))) {
							this.ins_reuniao_participante(	reuniao_id 	= retorno.reuniao_id,
															recurso_id	= v_recurso_id[count],
															observacao	= v_observacao[count]);
						} else {
							this.upd_reuniao_participante(	reuniao_id 	= retorno.reuniao_id,
															recurso_id	= v_recurso_id[count],
															observacao	= v_observacao[count],
															participante_id = v_participante_id[count]);
						}
					</cfscript>
				</cfloop>
				<!--- Assuntos --->
				<cfscript>
					v_assunto_id = this.ListaToArray (lista = arguments, variavel = "ASSUNTO_ID_ASSUNTOS");
					v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_ASSUNTO_ASSUNTOS");
					v_conclusao = this.ListaToArray (lista = arguments, variavel = "CONCLUSAO_ASSUNTO_ASSUNTOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ASSUNTOS, lista2 = ArrayToList(v_assunto_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_reuniao_assunto (reuniao_id = retorno.reuniao_id,
												assunto_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_assunto_id)#" index="count">
					<cfscript>
						if(not len(trim(v_assunto_id[count]))) {
							this.ins_reuniao_assunto(	reuniao_id 	= retorno.reuniao_id,
														descricao	= v_descricao[count],
														conclusao 	= v_conclusao[count]);
						} else {
							this.upd_reuniao_assunto(	reuniao_id 	= retorno.reuniao_id,
														descricao	= v_descricao[count],
														conclusao	= v_conclusao[count],
														assunto_id	= v_assunto_id[count]);
						}
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Reuniao alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma reuniao
	-- cristofer 26/09/2006 17:06:10 - CRIADO
	--->
	<cffunction name='del_reuniao' displayname='Exclui uma reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='REUNIAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_del_reuniao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REUNIAO_ID'  value='#arguments.REUNIAO_ID#'  null='#iif(len(trim(arguments.REUNIAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Reuniao excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Insere um assunto na reuniao
	-- cristofer 26/09/2006 17:07:14 - CRIADO
	--->
	<cffunction name='ins_reuniao_assunto' displayname='Insere um assunto na reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='REUNIAO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='CONCLUSAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_ins_reuniao_assunto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REUNIAO_ID'  value='#arguments.REUNIAO_ID#'  null='#iif(len(trim(arguments.REUNIAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_CONCLUSAO'  value='#arguments.CONCLUSAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ASSUNTO_ID' variable='retorno.ASSUNTO_ID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera um assunto na reuniao
	-- cristofer 26/09/2006 17:07:54 - CRIADO
	--->
	<cffunction name='upd_reuniao_assunto' displayname='Altera um assunto na reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='ASSUNTO_ID' required='yes'>
		<cfargument name='REUNIAO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='CONCLUSAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_alt_reuniao_assunto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ASSUNTO_ID'  value='#arguments.ASSUNTO_ID#'  null='#iif(len(trim(arguments.ASSUNTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REUNIAO_ID'  value='#arguments.REUNIAO_ID#'  null='#iif(len(trim(arguments.REUNIAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_CONCLUSAO'  value='#arguments.CONCLUSAO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera um assunto na reuniao
	-- cristofer 26/09/2006 17:07:54 - CRIADO
	--->
	<cffunction name='upd_reuniao_assunto_status' displayname='Altera um assunto na reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='ASSUNTO_ID' required='yes'>
		<cfargument name='CONCLUSAO' required='yes'>
		<cfargument name='DISCUTIDO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_alt_reuniao_assunto_status' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ASSUNTO_ID'  value='#arguments.ASSUNTO_ID#'  null='#iif(len(trim(arguments.ASSUNTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_CONCLUSAO'  value='#arguments.CONCLUSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISCUTIDO'  value='#arguments.DISCUTIDO#'  null='#iif(len(trim(arguments.DISCUTIDO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera um assunto na reuniao
	-- cristofer 26/09/2006 17:07:54 - CRIADO
	--->
	<cffunction name='upd_reuniao_status' displayname='Altera um assunto na reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='REUNIAO_ID' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cfargument name='INICIO' required='yes'>
		<cfargument name='TERMINO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<!--- Assuntos --->
				<cfscript>
					v_assunto_id = this.ListaToArray (lista = arguments, variavel = "ASSUNTO_ID_ASSUNTOS");
					v_conclusao = this.ListaToArray (lista = arguments, variavel = "CONCLUSAO");
					v_discutido = this.ListaToArray (lista = arguments, variavel = "DISCUTIDO_ASSUNTO");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_assunto_id)#" index="count">
					<cfdump var="#v_conclusao#">
					<cfdump var="#v_assunto_id#">
					<cfdump var="#v_discutido#">
					<cfscript>
							this.upd_reuniao_assunto_status(	conclusao	= v_conclusao[count],
																assunto_id	= v_assunto_id[count],
																discutido	= v_discutido[count]);
					</cfscript>
				</cfloop>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_alt_reuniao_status' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REUNIAO_ID'  value='#arguments.REUNIAO_ID#'  null='#iif(len(trim(arguments.REUNIAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INICIO'  value='#arguments.INICIO#' null='#iif(len(trim(arguments.INICIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TERMINO'  value='#arguments.TERMINO#' null='#iif(len(trim(arguments.TERMINO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					
					this.upd_reuniao_anexos_private(argumentCollection = arguments);
				</cfscript>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Reuniao salva com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Exclui um assunto na reuniao
	-- cristofer 26/09/2006 17:08:20 - CRIADO
	--->
	<cffunction name='del_reuniao_assunto' displayname='Exclui um assunto na reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='ASSUNTO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_del_reuniao_assunto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ASSUNTO_ID'  value='#arguments.ASSUNTO_ID#'  null='#iif(len(trim(arguments.ASSUNTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um participante na reuniao
	-- cristofer 26/09/2006 17:09:12 - CRIADO
	--->
	<cffunction name='ins_reuniao_participante' displayname='Insere um participante na reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='REUNIAO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_ins_reuniao_participante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REUNIAO_ID'  value='#arguments.REUNIAO_ID#'  null='#iif(len(trim(arguments.REUNIAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PARTICIPANTE_ID' variable='retorno.PARTICIPANTE_ID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um participante na reuniao
	-- cristofer 26/09/2006 17:09:51 - CRIADO
	--->
	<cffunction name='upd_reuniao_participante' displayname='Altera um participante na reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='PARTICIPANTE_ID' required='yes'>
		<cfargument name='REUNIAO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_alt_reuniao_participante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PARTICIPANTE_ID'  value='#arguments.PARTICIPANTE_ID#'  null='#iif(len(trim(arguments.PARTICIPANTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REUNIAO_ID'  value='#arguments.REUNIAO_ID#'  null='#iif(len(trim(arguments.REUNIAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um participante na reuniao
	-- cristofer 26/09/2006 17:10:14 - CRIADO
	--->
	<cffunction name='del_reuniao_participante' displayname='Exclui um participante na reuniao' access='remote' returntype='Struct' output='true'>
		<cfargument name='PARTICIPANTE_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_del_reuniao_participante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PARTICIPANTE_ID'  value='#arguments.PARTICIPANTE_ID#'  null='#iif(len(trim(arguments.PARTICIPANTE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Vincula uma reuniao a tarefa
	-- cristofer 26/09/2006 17:07:54 - CRIADO
	--->
	<cffunction name='ins_reuniao_assunto_tarefa' displayname='Vincula uma reuniao a tarefa' access='remote' returntype='Struct' output='true'>
		<cfargument name='ASSUNTO_ID' required='yes'>
		<cfargument name='TAREFA_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_ins_reuniao_assunto_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ASSUNTO_ID'  value='#arguments.ASSUNTO_ID#'  null='#iif(len(trim(arguments.ASSUNTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

<!--- 
	-- PROPSITO 
	-- Insere um anexo 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_anexo" displayname="" access="remote" returntype="Struct" output="true">
		<cfargument name="titulo" required="yes">
		<cfargument name="anexo" required="no" default="">
		<cfargument name="permite_excluir" required="no" default="0">
		<cfargument name="grupo_id" required="no" default="1">
		<cfargument name="filefield" required="no" default="anexo">
		<cftry>
			<cftransaction action="begin">
				<cfscript>
					retorno = this.ins_anexo_private(argumentCollection = arguments);
				</cfscript>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere um anexo 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_anexo_private" displayname="" access="remote" returntype="Struct" output="true">
		<cfargument name="titulo" required="yes">
		<cfargument name="anexo" required="no" default="">
		<cfargument name="permite_excluir" required="no" default="0">
		<cfargument name="grupo_id" required="no" default="1">
		<cfargument name="filefield" required="no" default="anexo">
				<cfset v_anexo = ''>
				<cfset v_arquivo = ''>
				<cfset retorno.url = ''>
				<cfif len(trim(arguments[arguments.filefield]))>
					<cffile action="upload"
							filefield="#arguments.filefield#" 
							nameconflict="makeunique"
							destination="#arguments[arguments.filefield]#2"
							result="arguments.dados">
				<!--- torna o nome do anexo unico --->
					<cfset dest = this.unique_filename(filename = ExpandPath('/documentos/')&arguments.dados.clientfile)>
					<cffile action="copy" 
							source="#arguments[arguments.filefield]#" 
							destination="#dest#"
							nameconflict="error"
							result="arguments.dados">
					<cfif not len(trim(arguments.titulo))>
						<cfset arguments.titulo = ListDeleteAt(arguments.dados.clientfile,listlen(arguments.dados.clientfile,'.'),'.')>
					</cfif>
					<cfset v_anexo = Replace(dest, ExpandPath('/documentos/'), 'http://portal.kmm.com.br/documentos/','one')>
					<cfset retorno.url = v_anexo>
				</cfif>
				<cfstoredproc procedure="kmm.pkg_anexo.prc_ins_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_titulo" type="in" value="#arguments.titulo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_url" type="in" value="#v_anexo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_permite_excluir" type="in" value="#arguments.permite_excluir#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_grupo_id" type="in" value="#arguments.grupo_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_anexo_id" type="out" variable="retorno.anexo_id" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Anexo inserido com sucesso!")>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca um nome unico para o anexo
	-- CRISTOFER  16/05/2006
	--->		
	<cffunction name="unique_filename" access="package" output="false" returntype="string">
		<cfargument name="filename" required="yes">
		<cfargument name="original" required="no" default="#arguments.filename#">
		<cfargument name="tentativa" required="no" default="0">
		<cfif not FileExists(arguments.filename)>
			<cfreturn arguments.filename>
		<cfelse>
			<cfscript>
				ext = ListLast(arguments.original,'.');
				t = ListDeleteAt(arguments.original, listlen(arguments.original,'.'), '.');
			</cfscript>
			<cfreturn this.unique_filename(	filename = t&'('&(arguments.tentativa+1)&').'&ext,
											original = arguments.original,
											tentativa = arguments.tentativa+1)>
		</cfif>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Insere um anexo 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_anexo" displayname="" access="remote" returntype="Struct" output="true">
		<cfargument name="anexo_id" required="yes">
		<cfargument name="titulo" required="yes">
		<cfargument name="anexo" required="no" default="">
		<cfargument name="permite_excluir" required="no" default="0">
		<cfargument name="grupo_id" required="no" default="1">
		<cfargument name="filefield" required="no" default="anexo">
		<cftry>
			<cftransaction action="begin">
				<cfset v_anexo = ''>
				<cfset v_arquivo = ''>
				<cfif len(trim(arguments[arguments.filefield]))>
					<cffile action="upload"
							filefield="#arguments.filefield#" 
							nameconflict="makeunique"
							destination="#arguments[arguments.filefield]#2"
							result="arguments.dados">
				<!--- torna o nome do anexo unico --->
					<cfset dest = this.unique_filename(filename = ExpandPath('/portal/documentos/')&arguments.dados.clientfile)>
					<cffile action="copy" 
							source="#arguments[arguments.filefield]#" 
							destination="#dest#"
							nameconflict="error"
							result="arguments.dados">
					<cfset v_anexo = Replace(dest, ExpandPath('/documentos/'), 'http://portal.kmm.com.br/documentos/','one')>
					<cfset retorno.url = v_anexo>
				</cfif>
				<cfstoredproc procedure="kmm.pkg_anexo.prc_alt_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_titulo" type="in" value="#arguments.titulo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_url" type="inout" variable="retorno.url" value="#v_anexo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_permite_excluir" type="in" value="#arguments.permite_excluir#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_grupo_id" type="in" value="#arguments.grupo_id#" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Anexo alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Exclui um anexo 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_anexo" access="remote" returntype="Struct" output="true">
		<cfargument name="anexo_id" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="kmm.pkg_anexo.prc_del_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_url" type="out" variable="retorno.url" cfsqltype="cf_sql_varchar">
				</cfstoredproc>
				<cfif len(trim(retorno.url))>
					<cftry>
						<cffile action="delete"
								file="#Replace(retorno.url,'http://portal.kmm.com.br/',ExpandPath('/portal/'),'all')#">
						<cfset retorno.erro = false>
						<cfcatch>
						</cfcatch>
					</cftry>
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Anexo excluido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um grupo de anexos
	-- cristofer 11/05/2006 11:35:45 - CRIADO
	--->
	<cffunction name='ins_anexo_grupo' displayname='Insere um grupo de anexos' access='remote' returntype='Struct' output='true'>;
		<cfargument name='GRUPO_PAI_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfif not len(trim(arguments.grupo_pai_id))>
					<cfset arguments.grupo_pai_id = 0>
				</cfif>
				<cfstoredproc procedure='kmm.pkg_anexo.prc_ins_anexo_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_PAI_ID'  value='#arguments.GRUPO_PAI_ID#'  null='#iif(len(trim(arguments.GRUPO_PAI_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID' variable='retorno.GRUPO_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um grupo de anexos
	-- cristofer 11/05/2006 11:36:40 - CRIADO
	--->
	<cffunction name='upd_anexo_grupo' displayname='Altera um grupo de anexos' access='remote' returntype='Struct' output='true'>;
		<cfargument name='GRUPO_ID' required='yes'>
		<cfargument name='GRUPO_PAI_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfif not len(trim(arguments.grupo_pai_id))>
					<cfset arguments.grupo_pai_id = 0>
				</cfif>
				<cfstoredproc procedure='kmm.pkg_anexo.prc_alt_anexo_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_PAI_ID'  value='#arguments.GRUPO_PAI_ID#'  null='#iif(len(trim(arguments.GRUPO_PAI_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um grupo de anexos
	-- cristofer 11/05/2006 11:37:21 - CRIADO
	--->
	<cffunction name='del_anexo_grupo' displayname='Exclui um grupo de anexos' access='remote' returntype='Struct' output='true'>;
		<cfargument name='GRUPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_anexo.prc_del_anexo_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um anexo ao projeto
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='ins_projeto_anexo' displayname='Insere um anexo ao projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ANEXO_ID' variable="retorno.projeto_anexo_id">
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera um anexo no projeto
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='upd_projeto_anexo' displayname='altera um anexo ao projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ANEXO_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ANEXO_ID'  value='#arguments.PROJETO_ANEXO_ID#'  null='#iif(len(trim(arguments.PROJETO_ANEXO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui um anexo no projeto
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='del_projeto_anexo' displayname='Exclui um anexo ao projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ANEXO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ANEXO_ID'  value='#arguments.PROJETO_ANEXO_ID#'  null='#iif(len(trim(arguments.PROJETO_ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um anexo ao projeto
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='ins_projeto_wbs_anexo' displayname='Insere um anexo ao projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_wbs_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('WBS salva com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um anexo a tarefa
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='ins_tarefa_anexo' displayname='Insere um anexo a tarefa' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='TAREFA_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_ins_tarefa_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um anexo a tarefa
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='del_tarefa_anexo' displayname='Exclui um anexo a tarefa' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='TAREFA_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_del_tarefa_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Adia uma tarefa
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='adiar_tarefa' displayname='Adia uma tarefa' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='ENTREGAR_EM' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_adiar_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGAR_EM'  value='#arguments.ENTREGAR_EM#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa adiada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere aplicao.
	-- arlen 05/10/2006 11:20:39 - CRIADO
	--->
	<cffunction name='ins_aplicacao' displayname='Insere aplicao.' access='remote' returntype='Struct' output='true'>
		<cfargument name='APLICACAO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ATIVO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_ins_aplicacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_APLICACAO'  value='#arguments.APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID' variable='retorno.APLICACAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Aplicao inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera aplicao.
	-- arlen 05/10/2006 11:22:52 - CRIADO
	--->
	<cffunction name='upd_aplicacao' displayname='Altera aplicao.' access='remote' returntype='Struct' output='true'>
		<cfargument name='APLICACAO_ID' required='yes'>
		<cfargument name='APLICACAO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ATIVO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_alt_aplicacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_APLICACAO'  value='#arguments.APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Aplicao alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui aplicao.
	-- arlen 05/10/2006 11:24:22 - CRIADO
	--->
	<cffunction name='del_aplicacao' displayname='Exclui aplicao.' access='remote' returntype='Struct' output='true'>
		<cfargument name='APLICACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_global.prc_del_aplicacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Aplicao excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	

	<!--- 
	-- PROPSITO
	-- Insere um arquivo
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='ins_arquivo_caminho' displayname='Exclui um anexo a tarefa' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CAMINHO' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_arquivo.prc_ins_arquivo_caminho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMINHO'  value='#replace(arguments.CAMINHO, "\","/","all")#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ARQUIVO_ID' variable="retorno.arquivo_id">
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um arquivo
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='ins_tarefa_arquivo' displayname='Exclui um anexo a tarefa' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='ARQUIVO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_ins_tarefa_arquivo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_ARQUIVO_ID'  value='#arguments.ARQUIVO_ID#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui um arquivo
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='del_tarefa_arquivo' displayname='Exclui um anexo a tarefa' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='ARQUIVO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_del_tarefa_arquivo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_ARQUIVO_ID'  value='#arguments.ARQUIVO_ID#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um anexo na reuniao
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='ins_reuniao_anexo' displayname='Insere um anexo na reuniao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REUNIAO_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_ins_reuniao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_REUNIAO_ID'  value='#arguments.REUNIAO_ID#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera um anexo na reuniao
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='upd_reuniao_anexo' displayname='Altera um anexo na reuniao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REUNIAO_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='ANEXO_ID_OLD' required='yes'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_alt_reuniao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_REUNIAO_ID'  value='#arguments.REUNIAO_ID#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_ANEXO_ID_OLD'  value='#arguments.ANEXO_ID_OLD#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um anexo na reuniao
	-- cristofer 02/10/2006 11:37:21 - CRIADO
	--->
	<cffunction name='del_reuniao_anexo' displayname='Exclui um anexo na reuniao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REUNIAO_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_reuniao.prc_del_reuniao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_REUNIAO_ID'  value='#arguments.REUNIAO_ID#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere uma alterao de requisito
	-- cristofer 11/10/2006 11:40:00 - CRIADO
	--->
	<cffunction name='ins_requisito_alteracao' displayname='Insere uma alterao de requisito' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='REQUISITO_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='COMPLEXIDADE_ID' required='yes'>
		<cfargument name='TAMANHO_ID' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='HORAS_AJUSTADO' required='yes'>
		<cfargument name='MINUTOS_AJUSTADO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_ins_requisito_alteracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPLEXIDADE_ID'  value='#arguments.COMPLEXIDADE_ID#'  null='#iif(len(trim(arguments.COMPLEXIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAMANHO_ID'  value='#arguments.TAMANHO_ID#'  null='#iif(len(trim(arguments.TAMANHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORAS_AJUSTADO'  value='#arguments.HORAS_AJUSTADO#'  null='#iif(len(trim(arguments.HORAS_AJUSTADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MINUTOS_AJUSTADO'  value='#arguments.MINUTOS_AJUSTADO#'  null='#iif(len(trim(arguments.MINUTOS_AJUSTADO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERACAO_ID' variable='retorno.ALTERACAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Alteracao inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma alterao de requisito
	-- cristofer 11/10/2006 11:40:42 - CRIADO
	--->
	<cffunction name='upd_requisito_alteracao' displayname='Altera uma alterao de requisito' access='remote' returntype='Struct' output='true'>
		<cfargument name='ALTERACAO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='REQUISITO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='COMPLEXIDADE_ID' required='yes'>
		<cfargument name='TAMANHO_ID' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='HORAS_AJUSTADO' required='yes'>
		<cfargument name='MINUTOS_AJUSTADO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_alt_requisito_alteracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERACAO_ID'  value='#arguments.ALTERACAO_ID#'  null='#iif(len(trim(arguments.ALTERACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPLEXIDADE_ID'  value='#arguments.COMPLEXIDADE_ID#'  null='#iif(len(trim(arguments.COMPLEXIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAMANHO_ID'  value='#arguments.TAMANHO_ID#'  null='#iif(len(trim(arguments.TAMANHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORAS_AJUSTADO'  value='#arguments.HORAS_AJUSTADO#'  null='#iif(len(trim(arguments.HORAS_AJUSTADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MINUTOS_AJUSTADO'  value='#arguments.MINUTOS_AJUSTADO#'  null='#iif(len(trim(arguments.MINUTOS_AJUSTADO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Alteracao do requisito alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma alterao de requisito
	-- cristofer 11/10/2006 11:41:09 - CRIADO
	--->
	<cffunction name='del_requisito_alteracao' displayname='Exclui uma alterao de requisito' access='remote' returntype='Struct' output='true'>
		<cfargument name='ALTERACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_del_requisito_alteracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERACAO_ID'  value='#arguments.ALTERACAO_ID#'  null='#iif(len(trim(arguments.ALTERACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Alteracao do requisito excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma alterao de requisito
	-- cristofer 11/10/2006 11:41:09 - CRIADO
	--->
	<cffunction name='aprova_requisito_alteracao' displayname='Exclui uma alterao de requisito' access='remote' returntype='Struct' output='true'>
		<cfargument name='ALTERACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_aprova_requisito_alteracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERACAO_ID'  value='#arguments.ALTERACAO_ID#'  null='#iif(len(trim(arguments.ALTERACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Alteracao do requisito aprovada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma alterao de requisito
	-- cristofer 11/10/2006 11:41:09 - CRIADO
	--->
	<cffunction name='recusa_requisito_alteracao' displayname='Exclui uma alterao de requisito' access='remote' returntype='Struct' output='true'>
		<cfargument name='ALTERACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_recusa_requisito_alteracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERACAO_ID'  value='#arguments.ALTERACAO_ID#'  null='#iif(len(trim(arguments.ALTERACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Alteracao do requisito recusada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Insere uma SMR
	-- cristofer 13/10/2006 16:12:13 - CRIADO
	--->
	<cffunction name='ins_requisito_solicitacao' displayname='Insere uma SMR' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='CRIADOR' required='yes'>
		<cfargument name='FORNECEDOR' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='URGENCIA_ID' required='yes'>
		<cfargument name='APLICACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_ins_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CRIADOR'  value='#arguments.CRIADOR#'  null='#iif(len(trim(arguments.CRIADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORNECEDOR'  value='#arguments.FORNECEDOR#'  null='#iif(len(trim(arguments.FORNECEDOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_URGENCIA_ID'  value='#arguments.URGENCIA_ID#'  null='#iif(len(trim(arguments.URGENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID' variable='retorno.SOLICITACAO_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID' variable='retorno.TAREFA_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitacao de Mudanca de Requisito inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma SMR
	-- cristofer 13/10/2006 16:12:58 - CRIADO
	--->
	<cffunction name='upd_requisito_solicitacao' displayname='Altera uma SMR' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='CRIADOR' required='yes'>
		<cfargument name='FORNECEDOR' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='URGENCIA_ID' required='yes'>
		<cfargument name='APLICACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_alt_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CRIADOR'  value='#arguments.CRIADOR#'  null='#iif(len(trim(arguments.CRIADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORNECEDOR'  value='#arguments.FORNECEDOR#'  null='#iif(len(trim(arguments.FORNECEDOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_URGENCIA_ID'  value='#arguments.URGENCIA_ID#'  null='#iif(len(trim(arguments.URGENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitacao de Mudanca de Requisito alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera o status de uma SMR
	-- cristofer 13/10/2006 16:13:36 - CRIADO
	--->
	<cffunction name='upd_requisito_solicitacao_status' displayname='Altera o status de uma SMR' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_alt_solicitacao_status' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitacao de Mudanca de Requisito alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma SMR
	-- cristofer 13/10/2006 16:14:26 - CRIADO
	--->
	<cffunction name='del_requisito_solicitacao' displayname='Exclui uma SMR' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_requisito.prc_del_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitacao de Mudanca de Requisito excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Inicia uma discussao
	-- cristofer 19/05/2006 16:39:33 - CRIADO
	--->
	<cffunction name='ins_discussao' displayname='Inicia uma discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='RESPONSAVEL' required='no' default="#UCase(session.usuario)#">
		<cfargument name='DATA_INICIO' required='no' default="#LSDateFormat(now())# #LSTimeFormat(now(), 'hh:mm:ss')#">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_ins_discussao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISCUSSAO_ID' variable='retorno.DISCUSSAO_ID' >
				</cfstoredproc>
				<cfscript>
					v_recurso_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_RECURSOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RECURSOS, lista2 = ArrayToList(v_recurso_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_discussao_participante(discussao_id = retorno.discussao_id,
														recurso_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_recurso_id)#" index="count">
					<cfscript>
						this.ins_discussao_participante(discussao_id = retorno.discussao_id,
														recurso_id = v_recurso_id[count]);
					</cfscript>
				</cfloop>			
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Discussao iniciada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma discussao
	-- cristofer 19/05/2006 16:44:11 - CRIADO
	--->
	<cffunction name='upd_discussao' displayname='Altera uma discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='RESPONSAVEL' required='no' default="">
		<cfargument name='DATA_INICIO' required='no' default="">
		<cfargument name='SITUACAO_ID' required='no' default="1">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_alt_discussao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					retorno.discussao_id = arguments.discussao_id;
					v_recurso_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_RECURSOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RECURSOS, lista2 = ArrayToList(v_recurso_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_discussao_participante(discussao_id = retorno.discussao_id,
														recurso_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_recurso_id)#" index="count">
					<cfscript>
						this.ins_discussao_participante(discussao_id = retorno.discussao_id,
														recurso_id = v_recurso_id[count]);
					</cfscript>
				</cfloop>			
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Discussao alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera a situacao de uma discussao
	-- cristofer 19/05/2006 16:48:11 - CRIADO
	--->
	<cffunction name='situacao_discussao' displayname='Altera a situacao de uma discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_alt_situacao_discussao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Situacao alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma discussao
	-- cristofer 19/05/2006 16:44:50 - CRIADO
	--->
	<cffunction name='del_discussao' displayname='Exclui uma discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_del_discussao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Discussao excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um item na discussao
	-- cristofer 19/05/2006 16:50:16 - CRIADO
	--->
	<cffunction name='ins_discussao_item' displayname='Insere um item na discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='no' default="">
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='DATA' required='no' default="#LSDateFormat(now())# #LSTimeFormat(now())#:00">
		<cftry>
			<cftransaction action='begin'>
				<cfif not len(trim(arguments.recurso_id))>
					<cfscript>
						conn = CreateObject("component", "_transportes.consulta.cfc_desenvolvimento");
						qrRecurso = conn.get_recurso(usuario = session.usuario);
						qrDiscussao = conn.get_discussao(discussao_id = arguments.discussao_id);
						qrParticipante = conn.get_discussao_participante(discussao_id = arguments.discussao_id);
					</cfscript>
					<cfif not qrRecurso.recordcount>
						<cfthrow detail="Seu usurio no est cadastrado como recurso dos projetos!"
							 message="Seu usurio no est cadastrado como recurso dos projetos!">
					<cfelse>
						<cfset arguments.recurso_id = qrRecurso.recurso_id>
					</cfif>
				</cfif>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_ins_discussao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID' variable='retorno.ITEM_ID'  >
				</cfstoredproc>
				<cfscript>
	//				retorno.item_id = arguments.item_id;
					v_anexo_file = this.ListaToArray (lista = arguments, variavel = "ANEXO_ANEXOS");
					v_filefield = this.ListaToArray (lista = arguments, variavel = "FILEFIELD_ANEXOS");
					retorno.anexos = arraynew(1);
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_anexo_file)#" index="count">
					<cfscript>
						if(len(trim(v_anexo_file[count]))) {
							retorno.anexos[count] = this.ins_anexo_private(filefield = v_filefield[count],
																		   argumentCollection = arguments,
																		   titulo = '',
																		   permite_excluir = 1,
																		   grupo_id = 11);
							if(not retorno.anexos[count].erro) {
								this.ins_discussao_anexo(item_id = retorno.item_id,
														 anexo_id = retorno.anexos[count].anexo_id);
							}
						}
					</cfscript>
					<cfif len(trim(v_anexo_file[count])) and  retorno.anexos[count].erro>
						<cfthrow object="#retorno.anexos[count].mensagem#">
					</cfif>
				</cfloop>			
				<cfset titulo = "#qrDiscussao.titulo#">
				<cfset subtitulo = "Comentario enviado por #qrRecurso.descricao#">
				<cfset mensagem = "#arguments.TEXTO#<br><br>Clique <a href='http://portal.kmm.com.br/janela.cfm?URL=/aplicacoes/portal/documentacao/discussao/principal.cfm'>aqui</a> para visualizar ou participar das discusses">
				<cfoutput query="qrParticipante">
					<cfmail from="discussoes@kmm.com.br" to="#qrParticipante.email#" type="html" subject="Discusses - #session.usuario#">
						<cfinclude template="/aplicacoes/mensagem/email.cfm">
					</cfmail>
				</cfoutput>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Comentario inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um item na discussao
	-- cristofer 19/05/2006 16:51:00 - CRIADO
	--->
	<cffunction name='upd_discussao_item' displayname='Altera um item na discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_alt_discussao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Comentario alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um item na discussao
	-- cristofer 19/05/2006 16:51:42 - CRIADO
	--->
	<cffunction name='del_discussao_item' displayname='Exclui um item na discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_del_discussao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Comentario excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um anexo no item da discussao
	-- cristofer 19/05/2006 16:53:44 - CRIADO
	--->
	<cffunction name='ins_discussao_anexo' displayname='Insere um anexo no item da discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_ins_discussao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um anexo no item da discussao
	-- cristofer 19/05/2006 16:54:07 - CRIADO
	--->
	<cffunction name='del_discussao_anexo' displayname='Exclui um anexo no item da discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_del_discussao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um participante na discussao
	-- cristofer 19/05/2006 16:55:38 - CRIADO
	--->
	<cffunction name='ins_discussao_participante' displayname='Insere um participante na discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_ins_discussao_participante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um participante na discussao
	-- cristofer 19/05/2006 16:55:55 - CRIADO
	--->
	<cffunction name='del_discussao_participante' displayname='Exclui um participante na discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_del_discussao_participante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Inserir Solicitao
	-- carlossantos 11/08/2008 15:04:33 - CRIADO
	--->
	<cffunction name='ins_solicitacao' displayname='Inserir Solicitao' access='remote' returntype='Struct' output='true'>
    	
		<cfargument name='USUARIO_SOLICITACAO' required='no' default="#session.usuario#">
		<cfargument name='CLIENTE_ID' required='no'>
		<cfargument name='TIPO_APLICACAO_ID' required='no'>
		<cfargument name='CODIGO_ERRO_EMAIL' required='no'>
		<cfargument name='SEVERIDADE' required='no'>
		<cfargument name='USUARIO_TESTE' required='no'>
		<cfargument name='DESCRICAO_OPERACAO' required='no'>
		<cfargument name='INFORMACOES_ADICIONAIS' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_solicitacao.prc_ins_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_SOLICITACAO'  value='#arguments.USUARIO_SOLICITACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_APLICACAO_ID'  value='#arguments.TIPO_APLICACAO_ID#'  null='#iif(len(trim(arguments.TIPO_APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO_ERRO_EMAIL'  value='#arguments.CODIGO_ERRO_EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEVERIDADE'  value='#arguments.SEVERIDADE#'  null='#iif(len(trim(arguments.SEVERIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_TESTE'  value='#arguments.USUARIO_TESTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_OPERACAO'  value='#arguments.DESCRICAO_OPERACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INFORMACOES_ADICIONAIS'  value='#arguments.INFORMACOES_ADICIONAIS#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao inserida com Sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Alterar Solicitao
    -- carlossantos 11/08/2008 15:08:04 - CRIADO
    --->
    <cffunction name='alt_solicitacao' displayname='Alterar Solicitao' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='USUARIO_SOLICITACAO' required='no' default="#session.usuario#">
        <cfargument name='CLIENTE_ID' required='no'>
        <cfargument name='TIPO_APLICACAO_ID' required='no'>
        <cfargument name='CODIGO_ERRO_EMAIL' required='no'>
        <cfargument name='SEVERIDADE' required='no'>
        <cfargument name='USUARIO_TESTE' required='no'>
        <cfargument name='DESCRICAO_OPERACAO' required='no'>
        <cfargument name='INFORMACOES_ADICIONAIS' required='no'>
        <cfargument name='STATUS_ID' required='no' default="0">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_solicitacao.prc_alt_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_SOLICITACAO'  value='#arguments.USUARIO_SOLICITACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_APLICACAO_ID'  value='#arguments.TIPO_APLICACAO_ID#'  null='#iif(len(trim(arguments.TIPO_APLICACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO_ERRO_EMAIL'  value='#arguments.CODIGO_ERRO_EMAIL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEVERIDADE'  value='#arguments.SEVERIDADE#'  null='#iif(len(trim(arguments.SEVERIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_TESTE'  value='#arguments.USUARIO_TESTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_OPERACAO'  value='#arguments.DESCRICAO_OPERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INFORMACOES_ADICIONAIS'  value='#arguments.INFORMACOES_ADICIONAIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao alterada com Sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    <!--- 
	-- PROPSITO
	-- Excluir Solicitao
	-- carlossantos 11/08/2008 15:13:20 - CRIADO
	--->
	<cffunction name='del_solicitacao' displayname='Excluir Solicitao' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_solicitacao.prc_del_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao excluda com Sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um mdulo
	-- jonas 31/03/2009 15:58:51 - CRIADO
	--->
	<cffunction name='ins_modulo' displayname='Insere um mdulo' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_MODULO' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_ins_modulo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODULO_ID' variable='retorno.MODULO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODULO'  value='#arguments.COD_MODULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Mdulo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>   
    
    <!--- 
	-- PROPSITO
	-- Altera um mdulo
	-- jonas 31/03/2009 16:01:27 - CRIADO
	--->
	<cffunction name='upd_modulo' displayname='Altera um mdulo' access='remote' returntype='Struct' output='true'>
		<cfargument name='MODULO_ID' required='yes'>
		<cfargument name='COD_MODULO' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_modulo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODULO_ID'  value='#arguments.MODULO_ID#'  null='#iif(len(trim(arguments.MODULO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODULO'  value='#arguments.COD_MODULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Mdulo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um mdulo
    -- jonas 31/03/2009 16:03:52 - CRIADO
    --->
    <cffunction name='del_modulo' displayname='Exclui um mdulo' access='remote' returntype='Struct' output='true'>
        <cfargument name='MODULO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_producao.prc_del_modulo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODULO_ID'  value='#arguments.MODULO_ID#'  null='#iif(len(trim(arguments.MODULO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Mdulo excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincula os Mdulos a um Cliente
	-- ANDERSONC 03/04/2009 14:57:47 - CRIADO
	--->
	<cffunction name='set_cliente_modulo' displayname='Vincula os Mdulos a um Cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='MODULOS' required='yes'>
        <cftry>
            <cftransaction action='begin'>
            	<cfscript>
					v_modulos = ListToArray(arguments.MODULOS, ';');
					
					conn = CreateComponent("_transportes.consulta.cfc_kmm");
					qrModuloCliente = conn.get_modulos_cliente(cliente_id = arguments.CLIENTE_ID);
				</cfscript>
                <cfloop query="qrModuloCliente">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_modulos)#" index="count">
						<cfscript>
							if(qrModuloCliente.MODULO_ID eq v_modulos[count]) {
								v_flag = 1;
								break;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_cliente_modulo(CONTROLE_ID = qrModuloCliente.CONTROLE_ID);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_modulos)#" index="count">
                	<cfscript>
						v_flag = 0;
					</cfscript>
					
					<cfloop query="qrModuloCliente">
						<cfscript>
							if(v_modulos[count] eq qrModuloCliente.MODULO_ID) {
								v_flag = 1;
								break;
							}							
						</cfscript>
					</cfloop>
					
					<cfscript>
						if(v_flag eq 0) {
							ret = this.ins_cliente_modulo(CLIENTE_ID = arguments.CLIENTE_ID,
														  MODULO_ID  = v_modulos[count],
														  ATIVO      = 1);
						}
					</cfscript>
                </cfloop>
            
            	<cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Mdulo(s) vinculados com sucesso ao cliente!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincula um Mdulo a um Cliente
	-- ANDERSONC 03/04/2009 14:57:47 - CRIADO
	--->
	<cffunction name='ins_cliente_modulo' displayname='Vincula um Mdulo a um Cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='MODULO_ID' required='yes'>
		<cfargument name='ATIVO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_ins_cliente_modulo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODULO_ID'  value='#arguments.MODULO_ID#'  null='#iif(len(trim(arguments.MODULO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.P_ROWID' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincula um Mdulo a um Cliente
	-- ANDERSONC 03/04/2009 14:59:51 - CRIADO
	--->
	<cffunction name='upd_cliente_modulo' displayname='Vincula um Mdulo a um Cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='MODULO_ID' required='yes'>
		<cfargument name='ATIVO' required='yes'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_cliente_modulo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODULO_ID'  value='#arguments.MODULO_ID#'  null='#iif(len(trim(arguments.MODULO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um Mdulo de um Cliente
	-- ANDERSONC 03/04/2009 15:02:04 - CRIADO
	--->
	<cffunction name='del_cliente_modulo' displayname='Exclui um Mdulo de um Cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_del_cliente_modulo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>    

	<!--- 
    -- PROPSITO
    -- Vincula modulo ao projeto
    -- guto 04/04/2009 14:50:49 - CRIADO
    --->
    <cffunction name='ins_projeto_modulo' displayname='Vincula modulo ao projeto' access='remote' returntype='Struct' output='true'>
        <cfargument name='PROJETO_ID' required='yes'>
        <cfargument name='MODULO_ID' required='yes'>
        <cfargument name='ATIVO' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='VERSAO' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_projeto.prc_ins_projeto_modulo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODULO_ID'  value='#arguments.MODULO_ID#'  null='#iif(len(trim(arguments.MODULO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VERSAO'  value='#arguments.VERSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='OUT' cfsqltype='cf_sql_varchar' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Mdulo vinculado com sucesso')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
    -- PROPSITO
    -- Altera vinculo do modulo ao projeto
    -- guto 04/04/2009 14:51:48 - CRIADO
    --->
    <cffunction name='upd_projeto_modulo' displayname='Altera vinculo do modulo ao projeto' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='PROJETO_ID' required='yes'>
        <cfargument name='MODULO_ID' required='yes'>
        <cfargument name='ATIVO' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='VERSAO' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_projeto.prc_alt_projeto_modulo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODULO_ID'  value='#arguments.MODULO_ID#'  null='#iif(len(trim(arguments.MODULO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VERSAO'  value='#arguments.VERSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Mdulo vinculado com sucesso')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
    -- PROPSITO
    -- Desvincula modulo do projeto
    -- guto 04/04/2009 14:52:30 - CRIADO
    --->
    <cffunction name='del_projeto_modulo' displayname='Desvincula modulo do projeto' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_projeto.prc_del_projeto_modulo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Mdulo desvinculado com sucesso')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

    <!--- 
    -- PROPSITO
    -- Insere modulo do projeto
    -- guto 04/04/2009 14:52:30 - CRIADO
    --->
    <cffunction name='projeto_modulo' displayname='Desvincula modulo do projeto' access='remote' returntype='Struct' output='true'>
        <cftry>
            <cftransaction action='begin'>
				<cfscript>
					v_controle_id = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_MODULO");
					v_modulo_id   = this.ListaToArray (lista = arguments, variavel = "MODULO_ID_MODULO");
					v_ativo       = this.ListaToArray (lista = arguments, variavel = "ATIVO_MODULO");
					v_versao      = this.ListaToArray (lista = arguments, variavel = "VERSAO_MODULO");
					v_observacao  = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_MODULO");
				    v_excluir 	  = this.ListDiff(lista1 = arguments.lista_deleted_MODULO, lista2 = ArrayToList(v_controle_id));
				</cfscript>
                
                <cfloop list="#v_excluir#" delimiters="," index="l_id">
                    <cfscript>
                        this.del_projeto_modulo (controle_id = l_id);
                    </cfscript>
                </cfloop>
                
				<cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                <cfdump var="#v_controle_id#">
					<cfscript>
						if(not len(trim(v_controle_id[count]))) {
							set_manipulacao = this.ins_projeto_modulo(projeto_id = arguments.PROJETO_ID,
																	  modulo_id  =  v_modulo_id[count],
																	  ativo      =  v_ativo[count],
																	  versao     =  v_versao[count],
																	  observacao =  v_observacao[count]);
						} else {
							set_manipulacao = this.upd_projeto_modulo(controle_id = v_controle_id[count],
																	  projeto_id = arguments.PROJETO_ID,
																	  modulo_id  =  v_modulo_id[count],
																	  ativo      =  v_ativo[count],
																	  versao     =  v_versao[count],
																	  observacao =  v_observacao[count]);
						}
					</cfscript>
					<cfif set_manipulacao.erro>
						<cfthrow object="#set_manipulacao.mensagem#">
					</cfif>
				</cfloop>			
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Mdulo vinculados com sucesso')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>        
</cfcomponent>